package com.rapid.j2ee.framework.mvc.ui.complexview.datasource;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

/**
 * 拼音WebViewComponentItem Wrapper
 * 
 * @author John Hao
 * 
 */
public class WebViewComponentItemPinYinWrapper implements WebViewComponentItem,
		WebViewComponentImage, Comparable<WebViewComponentItemPinYinWrapper> {

	private WebViewComponentItem item;

	public WebViewComponentItemPinYinWrapper(WebViewComponentItem item) {
		this.item = item;
	}

	public WebViewComponentItem getSource() {
		return this.item;
	}

	public String getImageAlt() {

		return (item instanceof WebViewComponentImage) ? ((WebViewComponentImage) item)
				.getImageAlt()
				: null;
	}

	public String getImageUrl() {

		return (item instanceof WebViewComponentImage) ? ((WebViewComponentImage) item)
				.getImageUrl()
				: null;
	}

	public String getOptionText() {

		return this.item.getOptionText();
	}

	public String getOptionKey() {

		return item.getOptionKey();
	}

	// 获得拼英Text
	public String getOptionPinYinText() {
		return StringUtils.encodeChineseByUpperCasePinYin(this.getOptionText());
	}

	// 获得一个字母的拼音
	public String getFirstCharPinYin() {

		String text = getOptionPinYinText();

		if (TypeChecker.isEmpty(text)) {
			return "";
		}

		return text.substring(0, 1);
	}

	// 按照拼音排序
	public int compareTo(WebViewComponentItemPinYinWrapper o) {
		return getOptionPinYinText().compareTo(o.getOptionPinYinText());
	}

}
