package com.rapid.j2ee.framework.mvc.ui.complexview.imagecrop;

import java.io.File;

import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.mvc.web.annotation.ModelDriven;

@ModelDriven
public class ImageCrop {

	private String _callback;

	private String _imageCropTitle;

	private File _photo;

	private String _photoFileName;

	private String _photoContextType;

	private String _photoPath;

	/**
	 * 图片剪切Target
	 */
	private int _photoTargetWidth;

	private int _photoTargetHeight;

	/**
	 * 图片剪切框Size
	 */
	private int _photoCropComponentWidth;

	private int _photoCropComponentHeight;

	private String _cagtegoryType;

	private int _photoX;

	private int _photoY;

	private float _photoCropHeight;

	private float _photoCropWidth;

	public String get_callback() {
		return _callback;
	}

	public void set_callback(String _callback) {
		this._callback = _callback;
	}

	public String get_cagtegoryType() {
		return StringUtils.trimToEmpty(_cagtegoryType, "CommonImageCrop");
	}

	public void set_cagtegoryType(String type) {
		_cagtegoryType = type;
	}

	public String get_imageCropTitle() {
		return _imageCropTitle;
	}

	public void set_imageCropTitle(String cropTitle) {
		_imageCropTitle = cropTitle;
	}

	public File get_photo() {
		return _photo;
	}

	public void set_photo(File _photo) {
		this._photo = _photo;
	}

	public String get_photoContextType() {
		return _photoContextType;
	}

	public void set_photoContextType(String contextType) {
		_photoContextType = contextType;
	}

	public String get_photoFileName() {
		return _photoFileName;
	}

	public void set_photoFileName(String fileName) {
		_photoFileName = fileName;
	}

	public String get_photoPath() {
		return _photoPath;
	}

	public void set_photoPath(String path) {
		_photoPath = path;
	}

	public int get_photoCropComponentHeight() {
		return _photoCropComponentHeight;
	}

	public void set_photoCropComponentHeight(int cropComponentHeight) {
		_photoCropComponentHeight = cropComponentHeight;
	}

	public int get_photoCropComponentWidth() {
		return _photoCropComponentWidth;
	}

	public void set_photoCropComponentWidth(int cropComponentWidth) {
		_photoCropComponentWidth = cropComponentWidth;
	}

	public int get_photoSourceHeight() {
		// 80 - Header+Bottom Bar
		return this._photoCropComponentHeight - 80 - 50;
	}

	public int get_photoSourceWidth() {

		return this._photoCropComponentWidth - this._photoTargetWidth - 100;
	}

	public int get_photoTargetHeight() {
		return _photoTargetHeight;
	}

	public void set_photoTargetHeight(int targetHeight) {
		_photoTargetHeight = targetHeight;
	}

	public int get_photoTargetWidth() {
		return _photoTargetWidth;
	}

	public void set_photoTargetWidth(int targetWidth) {
		_photoTargetWidth = targetWidth;
	}

	public float get_photoCropHeight() {
		return _photoCropHeight;
	}

	public void set_photoCropHeight(float cropHeight) {
		_photoCropHeight = cropHeight;
	}

	public float get_photoCropWidth() {
		return _photoCropWidth;
	}

	public void set_photoCropWidth(float cropWidth) {
		_photoCropWidth = cropWidth;
	}

	public int get_photoX() {
		return _photoX;
	}

	public void set_photoX(int _photox) {
		_photoX = _photox;
	}

	public int get_photoY() {
		return _photoY;
	}

	public void set_photoY(int _photoy) {
		_photoY = _photoy;
	}

}
