package com.rapid.j2ee.framework.mvc.ui.complexview.imagecrop;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.exception.ApplicationException;
import com.rapid.j2ee.framework.core.io.net.ResourceHttpGetClient;
import com.rapid.j2ee.framework.core.io.net.ResourceStorageClient;
import com.rapid.j2ee.framework.core.io.net.disk.ResourceDiskStorageClient;
import com.rapid.j2ee.framework.core.utils.DateTimeUtils;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.ImageCompressUtils;
import com.rapid.j2ee.framework.core.utils.ImageCropUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.support.DateTimeFormat;
import com.rapid.j2ee.framework.mvc.constants.OperationResultConstants;
import com.rapid.j2ee.framework.mvc.web.MvcWebActionSupport;
import com.rapid.j2ee.framework.mvc.web.annotation.MethodParameter;

public class ImageCropComponentAction extends MvcWebActionSupport {

	private static final long serialVersionUID = 1L;

	public String doUploadImageForCrop(ImageCrop imageCrop) {

		Assert.notNull(resourceStorageClient);

		// Compress File
		imageCrop.set_photo(ImageCompressUtils.compressPercentage(imageCrop
				.get_photo(), ImageCompressUtils.getFileByAlias(imageCrop
				.get_photo(), "cp"), imageCrop.get_photoSourceWidth(),
				imageCrop.get_photoSourceHeight()));

		imageCrop.set_photoPath(FileUtils.getFullFilePathsName(imageCrop
				.get_photo().getName(), imageCrop.get_cagtegoryType(),
				DateTimeUtils.getCurrentWebDate(DateTimeFormat.YYYY_MM_DD)));

		if (!resourceStorageClient.put(ImageCrop.class.getName(), imageCrop
				.get_photoPath(), imageCrop.get_photo())) {
			throw new ApplicationException(
					OperationResultConstants.FAILED_SUBMIT_UPLOAD_RESOURCE_ERROR);
		}

		FileUtils.delete(imageCrop.get_photo().getAbsolutePath());

		return "InitPage";
	}

	public void doDownloadImageForCrop(@MethodParameter("_imagePath")
	String imagePath, @MethodParameter("_photoFileName")
	String photoFileName, HttpServletRequest request,
			HttpServletResponse response) {

		resourceHttpGetClient.get(ImageCrop.class.getName(), imagePath,
				photoFileName, request, response);
	}

	public void doSaveCropImage(ImageCrop imageCrop) {

		File sourceFile = FileUtils.getFile(resourceStorageClient
				.getDirectory(ImageCrop.class.getName()), imageCrop
				.get_photoPath());

		if (!(resourceStorageClient instanceof ResourceDiskStorageClient)) {

			FileUtils.makeDir(sourceFile);

			FileOutputStream fileOutputStream = null;

			try {

				fileOutputStream = new FileOutputStream(sourceFile);

				if (!resourceStorageClient.get(ImageCrop.class.getName(),
						imageCrop.get_photoPath(), fileOutputStream)) {
					throw new ApplicationException(
							OperationResultConstants.FAILED_RESOURCE_NOT_FOUND);
				}
			} catch (FileNotFoundException e) {
				throw new ApplicationException(
						OperationResultConstants.FAILED_RESOURCE_NOT_FOUND);
			} finally {

				try {
					fileOutputStream.flush();
				} catch (Exception e) {

				}
				try {
					fileOutputStream.close();
				} catch (Exception e) {

				}
			}

		}

		File target = new File(sourceFile.getParentFile(), sourceFile.getName()
				+ "final");

		ImageCropUtils.cropImage(sourceFile, FileUtils
				.getFileNameAndExtension(imageCrop.get_photoFileName())[1],
				target, imageCrop.get_photoX(), imageCrop.get_photoY(),
				(int) imageCrop.get_photoCropWidth(), (int) imageCrop
						.get_photoCropHeight());

		if (!(resourceStorageClient instanceof ResourceDiskStorageClient)) {

			if (!resourceStorageClient.put(ImageCrop.class.getName(),
					StringUtils.substringBeforeLast(imageCrop.get_photoPath(),
							"/"), target.getName(), target)) {
				throw new ApplicationException(
						OperationResultConstants.FAILED_SUBMIT_UPLOAD_RESOURCE_ERROR);
			}

		}

		FileUtils.delete(sourceFile);

		throw new ApplicationException(
				OperationResultConstants.SUCCESS_SUBMIT_CROP);
	}

	public File getCropImageFile(String photoPath) {

		return FileUtils.getFile(resourceStorageClient
				.getDirectory(ImageCrop.class.getName()), photoPath);

	}

	public void setResourceHttpGetClient(
			ResourceHttpGetClient resourceHttpGetClient) {
		this.resourceHttpGetClient = resourceHttpGetClient;
	}

	public void setResourceStorageClient(
			ResourceStorageClient resourceStorageClient) {
		this.resourceStorageClient = resourceStorageClient;
	}

	private ResourceStorageClient resourceStorageClient;

	private ResourceHttpGetClient resourceHttpGetClient;

}
