package com.rapid.j2ee.framework.mvc.ui.complexview.pinyinwebview;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;

import com.rapid.j2ee.framework.core.collections.SortMultiHashMap;
import com.rapid.j2ee.framework.core.utils.ActionContext;
import com.rapid.j2ee.framework.mvc.ui.complexview.datasource.ComplexWebViewComponentDataSourceFactory;
import com.rapid.j2ee.framework.mvc.ui.complexview.datasource.WebViewComponentItemPinYinWrapper;
import com.rapid.j2ee.framework.mvc.ui.complexview.pinyinwebview.criteria.ComplexWebViewAsPinYinArrangementParameter;
import com.rapid.j2ee.framework.mvc.web.MvcWebActionSupport;

public class ComplexWebViewComponentPopupAction extends MvcWebActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * http://127.0.0.1:8080/GalaxyEarth/toolkit/generateComplexWebViewComponentAction.do?method=GenerateComplexWebViewAsPinYinArrangement
	 * &dataSourceName=DataSourceTester &containerWidth=600 &containerHeight=400
	 * &itemWidth=80
	 * 
	 * @param request
	 * @param parameter
	 * @param actionContext
	 * @return
	 */
	public String doPopupComplexWebViewAsPinYinArrangement(
			HttpServletRequest request,
			ComplexWebViewAsPinYinArrangementParameter parameter,
			ActionContext actionContext) {

		List<WebViewComponentItemPinYinWrapper> items = complexWebViewComponentDataSourceFactory
				.getDataSourceWrappedByPinYin(parameter.getDataSourceName(),
						request);

		// 26个字母
		SortMultiHashMap sortMultPinYinItems = new SortMultiHashMap(26);

		// 按照拼音分组
		for (WebViewComponentItemPinYinWrapper pinYinItem : items) {
			sortMultPinYinItems
					.put(pinYinItem.getFirstCharPinYin(), pinYinItem);
		}

		// 拼音的开头字母List
		actionContext.setObjectToContextMap("DataSourceAsKeys",
				sortMultPinYinItems.keyList());

		actionContext.setObjectToContextMap("DataSource", sortMultPinYinItems);

		// 保存参数到ActionContext中
		complexWebViewComponentPopupActionSupport
				.storeComplexWebViewProperties(
						complexWebViewComponentDataSourceFactory, parameter,
						actionContext, request);

		return "ComplexWebViewAsPinYinArrangement";
	}

	@Autowired
	private ComplexWebViewComponentDataSourceFactory complexWebViewComponentDataSourceFactory;

	@Autowired
	private ComplexWebViewComponentPopupActionSupport complexWebViewComponentPopupActionSupport;

}
