package com.rapid.j2ee.framework.mvc.ui.complexview.pinyinwebview;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.core.utils.ActionContext;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.ui.complexview.datasource.AbstractComplexWebViewComponentDataSource;
import com.rapid.j2ee.framework.mvc.ui.complexview.datasource.ComplexWebViewComponentDataSourceFactory;
import com.rapid.j2ee.framework.mvc.ui.complexview.pinyinwebview.criteria.ComplexWebViewAsPinYinArrangementParameter;

@Component
public class ComplexWebViewComponentPopupActionSupport {

	public void storeComplexWebViewProperties(
			ComplexWebViewComponentDataSourceFactory complexWebViewComponentDataSourceFactory,
			ComplexWebViewAsPinYinArrangementParameter parameter,
			ActionContext actionContext, HttpServletRequest request) {

		AbstractComplexWebViewComponentDataSource properties = (AbstractComplexWebViewComponentDataSource) complexWebViewComponentDataSourceFactory
				.getComplexWebViewComponentDataSource(parameter
						.getDataSourceName());

		actionContext.setObjectToContextMap("ContainerHeight", "height:"
				+ properties.getContainerHeight(request) + "px");
		actionContext.setObjectToContextMap("ContainerWidth", "width:"
				+ properties.getContainerWidth(request) + "px");
		actionContext.setObjectToContextMap("ItemWidth", "width:"
				+ properties.getItemWidth(request) + "px");
		actionContext.setObjectToContextMap("ContainerRemark", properties
				.getWebViewRemark(request));
		actionContext.setObjectToContextMap("ContainerTitle", properties
				.getWebViewTitle(request));

		actionContext.setObjectToContextMap("ContainerCallback", StringUtils
				.trimToEmpty(parameter.getCallback(), parameter
						.getDataSourceName()
						+ "Callback"));
		actionContext.setObjectToContextMap("ContainerDataSourceName",
				parameter.getDataSourceName());
		actionContext.setObjectToContextMap("ContainerMultiple", TypeChecker
				.isSpecialTrue(parameter.getMultiple()));
		actionContext.setObjectToContextMap("ContainerAlign", properties
				.getContainerAlign(request));

		actionContext.setObjectToContextMap("Parameter1", parameter
				.getParameter1());
		actionContext.setObjectToContextMap("Parameter2", parameter
				.getParameter2());
		actionContext.setObjectToContextMap("Parameter3", parameter
				.getParameter3());
		actionContext.setObjectToContextMap("Parameter4", parameter
				.getParameter4());
		actionContext.setObjectToContextMap("Parameter5", parameter
				.getParameter5());
		actionContext.setObjectToContextMap("RewrittenFieldId", parameter
				.getRewrittenFieldId());

	}
}
