package com.rapid.j2ee.framework.mvc.ui.complexview.verificationcode;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.RequestUtils;
import com.rapid.j2ee.framework.core.utils.ResponseUtils;
import com.rapid.j2ee.framework.core.utils.verificationcode.VerificationImageCodeGenerator;
import com.rapid.j2ee.framework.core.utils.verificationcode.VerificationImageCodeUtils;
import com.rapid.j2ee.framework.core.utils.verificationcode.VerificationSMSCodeUtils;
import com.rapid.j2ee.framework.mvc.web.MvcWebActionSupport;
import com.rapid.j2ee.framework.mvc.web.annotation.MethodParameter;

public class VerificationCodeGeneratorAction extends MvcWebActionSupport {

	public void doDrawVerificationCodeImage(HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		String verificationCode = verificationImageCodeGenerator
				.getVerificationImageCode(this.verficationCodeLength);

		VerificationImageCodeUtils.addVerificationImageCodeCookie(
				verificationCode, 60 * verificationCodeExpireMinTime);

		// save session
		if (this.sessionStorageOpen) {

			RequestUtils.setSessionMaxInactiveInterval(request,
					60 * verificationCodeExpireMinTime);

			RequestUtils.getHttpSession(this.request).setAttribute(
					VerificationImageCodeUtils.class.getSimpleName(),
					verificationCode);
		}

		verificationImageCodeGenerator.drawVerificationCodeImage(response
				.getOutputStream(), verificationCode);

	}

	/**
	 * 
	 * 用于手机端获取Verification code
	 * 
	 * @param request
	 * 
	 * @param response
	 * 
	 * @throws Exception
	 */
	public void doDrawVerificationCodeAppImage(HttpServletRequest request,
			HttpServletResponse response) throws Exception {

		String verificationCode = verificationImageCodeGenerator
				.getVerificationImageCode(this.verficationCodeLength);

		ResponseUtils.setNoCacheResponse(response);

		// Set Header Verification Hashcode
		response.setHeader("verificationHashcode", VerificationImageCodeUtils
				.getVerificationImageHashcode(verificationCode));

		verificationImageCodeGenerator.drawVerificationCodeImage(response
				.getOutputStream(), verificationCode);

	}

	public void doSendSMSVerificationCode(@MethodParameter("mobileNo")
	String mobileNo, @MethodParameter("functionType")
	String functionType, HttpServletRequest request, HttpServletResponse respons) {

		Assert.notNull(smsVerificationCodeSender,
				"Please provide a SMS Verification Code Sender!!!!");

		String verificationCode = VerificationSMSCodeUtils
				.nextVerificationCode(verficationCodeSMSLength);

		VerificationSMSCodeUtils.addVerificationCodeCookie(mobileNo,
				verificationCode, 60 * verificationCodeSMSExpireMinTime);

		// save session
		if (this.sessionStorageOpen) {

			RequestUtils.setSessionMaxInactiveInterval(request,
					60 * verificationCodeSMSExpireMinTime);

			RequestUtils.getHttpSession(this.request).setAttribute(
					VerificationSMSCodeUtils.class.getSimpleName(),
					verificationCode);
		}

		smsVerificationCodeSender
				.send(functionType, mobileNo, verificationCode);
	}

	public void setVerificationCodeExpireMinTime(
			int verificationCodeExpireMinTime) {
		this.verificationCodeExpireMinTime = verificationCodeExpireMinTime;
	}

	public void setVerificationCodeSMSExpireMinTime(
			int verificationCodeSMSExpireMinTime) {
		this.verificationCodeSMSExpireMinTime = verificationCodeSMSExpireMinTime;
	}

	public void setSmsVerificationCodeSender(
			SMSVerificationCodeSender smsVerificationCodeSender) {
		this.smsVerificationCodeSender = smsVerificationCodeSender;
	}

	public void setVerficationCodeLength(int verficationCodeLength) {
		this.verficationCodeLength = verficationCodeLength;
	}

	public void setVerficationCodeSMSLength(int verficationCodeSMSLength) {
		this.verficationCodeSMSLength = verficationCodeSMSLength;
	}

	public void setSessionStorageOpen(boolean sessionStorageOpen) {
		this.sessionStorageOpen = sessionStorageOpen;
	}

	@Autowired
	private VerificationImageCodeGenerator verificationImageCodeGenerator;

	@Autowired(required = false)
	private SMSVerificationCodeSender smsVerificationCodeSender;

	private int verificationCodeExpireMinTime = 15;

	private int verificationCodeSMSExpireMinTime = 5;

	private int verficationCodeSMSLength = 6;

	private int verficationCodeLength = 4;

	private boolean sessionStorageOpen = true;

	private static final long serialVersionUID = 1L;

}
