package com.rapid.j2ee.framework.mvc.ui.complexview.verificationcode;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.mvc.security.logic.VerificationCodeSecurityAuthority;
import com.rapid.j2ee.framework.mvc.security.utils.MvcSecurityActionContextUtils;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public class VerificationCodeSecurityAuthorityInterceptor extends
		AbstractInterceptor {

	@Override
	public String intercept(ActionInvocation actionInvocation) throws Exception {

		String handler = actionInvocation.getAction().getClass().getName()
				+ "." + ActionContextUtils.getActionMethodName();

		if (!verificationCodeRequiredHandlers.contains(handler)) {

			Logger
					.info("VerificationCodeSecurityAuthorityInterceptor Ingore Key:"
							+ handler);

			return actionInvocation.invoke();
		}

		verificationCodeSecurityAuthority.doSecurityAuthorityVerifty(
				actionInvocation.getAction(), ActionContextUtils
						.getActionMethod());

		return actionInvocation.invoke();
	}

	public void setVerificationCodeSecurityAuthority(
			VerificationCodeSecurityAuthority verificationCodeSecurityAuthority) {
		this.verificationCodeSecurityAuthority = verificationCodeSecurityAuthority;
	}

	public void setVerificationCodeRequiredHandlers(
			List<String> verificationCodeRequiredHandlers) {
		this.verificationCodeRequiredHandlers = verificationCodeRequiredHandlers;
	}

	private VerificationCodeSecurityAuthority verificationCodeSecurityAuthority;

	private List<String> verificationCodeRequiredHandlers = ObjectUtils.EMPTY_LIST;

	private Log Logger = LogFactory
			.getLog(VerificationCodeSecurityAuthorityInterceptor.class);

}
