package com.rapid.j2ee.framework.mvc.ui.fieldstyle;

import java.util.Set;

import com.opensymphony.xwork2.ActionContext;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public abstract class AbstractUIHtmlFieldStyleSettingsController {

	public static final AbstractUIHtmlFieldStyleSettingsController Default_Instance = new AbstractUIHtmlFieldStyleSettingsController() {

		@Override
		protected Set<String> getHtmlFieldNamesForViewStyleSettings(
				Class actionClass, String method) {

			return ObjectUtils.EMPTY_SET;
		}
	};

	public AbstractUIHtmlFieldStyleSettingsController() {

	}

	public void autoHtmlFieldStyleSettingsForHiddenView() {

		if (UIHtmlFieldStyleSettingsHolder
				.isAutoHtmlFieldStyleSettingsInterrupted()) {

			UIHtmlFieldStyleSettingsHolder.remove();

			return;
		}

		Set<String> fieldNamesForView = this
				.getHtmlFieldNamesForViewStyleSettings(ActionContextUtils
						.getActionClass(), ActionContextUtils
						.getActionMethodName());

		if (TypeChecker.isEmpty(fieldNamesForView)) {
			return;
		}

		ActionContext.getContext().put(
				Html_Field_Style_HiddenView_Configure_Settings,
				fieldNamesForView);

	}

	protected abstract Set<String> getHtmlFieldNamesForViewStyleSettings(
			Class actionClass, String method);

	public static final String Html_Field_Style_HiddenView_Configure_Settings = "fieldStyleSets";
}
