package com.rapid.j2ee.framework.mvc.ui.fieldstyle;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public class UIHtmlFieldStylePropertiesSettingsController extends
		AbstractUIHtmlFieldStyleSettingsController {

	protected Log logger = LogFactory.getLog(this.getClass());

	@Override
	protected synchronized Set<String> getHtmlFieldNamesForViewStyleSettings(
			Class actionClass, String method) {

		String key = actionClass + "." + method;

		if (!htmlFieldViewMapper.containsKey(key)) {

			htmlFieldViewMapper.put(key,
					this._getHtmlFieldNamesForViewStyleSettings(actionClass,
							method));

		}

		return htmlFieldViewMapper.get(key);
	}

	private Set<String> _getHtmlFieldNamesForViewStyleSettings(
			Class actionClass, String method) {
		InputStream is = null;

		try {

			logger.info("HtmlFieldNamesForViewStyleSettings Configure:"
					+ actionClass.getSimpleName() + "_"
					+ Html_Field_Style_HiddenView_Configure_Settings
					+ ".properties");

			is = actionClass.getResourceAsStream(actionClass.getSimpleName()
					+ "_" + Html_Field_Style_HiddenView_Configure_Settings
					+ ".properties");

			Properties configures = new Properties();

			configures.load(is);

			logger.info("HtmlFieldNamesForViewStyleSettings key="
					+ getFieldSetKey(configures, method));

			String fieldSets = configures.getProperty(getFieldSetKey(
					configures, method));

			if (TypeChecker.isEmpty(fieldSets)) {
				return null;
			}

			return new HashSet<String>(Arrays.asList(StringUtils
					.splitBySeparators(fieldSets, ",", ";")));

		} catch (Exception e) {

			return null;
		} finally {
			try {
				is.close();
			} catch (Exception e) {

			}
		}
	}

	private String getFieldSetKey(Properties configures, String method) {

		String key = "FieldStyleSets.Method.do"
				+ StringUtils.upperStartChar(method);

		if (configures.containsKey(key)) {
			return key;
		}

		return "FieldStyleSets.Method." + method;
	}

	// htmlFieldViewMapper
	private Map<String, Set<String>> htmlFieldViewMapper = new HashMap<String, Set<String>>();

}
