package com.rapid.j2ee.framework.mvc.ui.freemarker;

import java.io.Writer;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

import freemarker.template.Template;

public abstract class AbstractFreemarkerTemplateGenerator {

	public AbstractFreemarkerTemplateGenerator() {
	}

	public void process() {

		Writer writer = null;

		try {

			writer = getOutputWriter();

			Template template = FreemarkerConfigurer
					.getConfiguration(getFreemarkerTemplateFolder())
					.getTemplate(this.getTemplate());

			template.process(this.getTemplateRootObject(), writer);

		} catch (Throwable e) {
			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {
			this.close(writer);
		}
	}

	protected abstract Writer getOutputWriter() throws Throwable;

	private void close(Writer writer) {
		try {
			writer.flush();
		} catch (Exception e) {

		}
		try {
			writer.close();
		} catch (Exception e) {

		}
	}

	protected abstract Object getTemplateRootObject();

	protected String getFreemarkerTemplateFolder() {
		return FileUtils.getFullFilePathName(FreemarkerConfigurer
				.getParameter("Freemarker.TemplateDir", "WEB-INF/template"),
				this.getTheme());
	}

	public String getTheme() {

		String theme = FreemarkerConfigurer
				.getParameter("Freemarker." + this.getClass().getSimpleName()
						+ ".Theme");

		if (!TypeChecker.isEmpty(theme)) {
			return theme;
		}

		return FreemarkerConfigurer.getParameter("Freemarker.Theme",
				"custome");
	}

	protected abstract String getTemplate();

}
