package com.rapid.j2ee.framework.mvc.ui.freemarker;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import javax.servlet.ServletContextEvent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.util.WebUtils;

import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;

import freemarker.template.Configuration;

@SuppressWarnings("unchecked")
public class FreemarkerConfigurer {

	private static final Log logger = LogFactory
			.getLog(AbstractFreemarkerTemplateGenerator.class);

	private static final Map<String, String> freemarkerParameters = new HashMap<String, String>();

	private static final Map<String, Configuration> freemarkConfiguration = new HashMap<String, Configuration>();

	private static String contextRootRealPath = null;

	public static void initConfigure(ServletContextEvent event) {

		synchronized (freemarkerParameters) {

			try {
				contextRootRealPath = WebUtils.getRealPath(event
						.getServletContext(), "");
			} catch (FileNotFoundException e) {

			}

			freemarkerParameters.clear();

			Enumeration<String> names = event.getServletContext()
					.getInitParameterNames();

			for (String name = null; names.hasMoreElements();) {

				name = names.nextElement();

				freemarkerParameters.put(name, event.getServletContext()
						.getInitParameter(name));

			}

		}

	}

	public static String getParameter(String name) {
		return getParameter(name, "");

	}

	public static String getParameter(String name, String defValue) {
		if (!freemarkerParameters.containsKey(name)) {
			return defValue;
		}

		return StringUtils
				.trimToEmpty(freemarkerParameters.get(name), defValue);
	}

	public static Configuration getConfiguration(String folder) {

		try {
			synchronized (freemarkConfiguration) {

				if (!freemarkConfiguration.containsKey(folder)) {

					Configuration cfg = new Configuration();

					File file = new File(contextRootRealPath, folder);

					cfg.setDirectoryForTemplateLoading(file);

					cfg.setEncoding(Locale.CHINA, getParameter(
							"Freemarker.Template.Encoding", "utf-8"));

					logger
							.info("Freemarker Configuration Template Path Folder:"
									+ file.getAbsolutePath());

					freemarkConfiguration.put(folder, cfg);

				}
			}

			return freemarkConfiguration.get(folder);

		} catch (Exception e) {

			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}
}
