package com.rapid.j2ee.framework.mvc.ui.json.select;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.rapid.j2ee.framework.core.utils.HttpRequestToJavaBeanUtils;
import com.rapid.j2ee.framework.mvc.ui.annotation.RequestResourceProvider;

public abstract class AbstractSelectOptionResourceProvider<T> implements
		SelectOptionResourceProvider {

	public List getSelectOptionResource(HttpServletRequest request,
			RequestResourceProvider selectOptionResourceProvider,
			SelectOptionJsonConfigurer selectOptionJsonConfigurer) {

		Class requestBeanClz = selectOptionResourceProvider.requestBeanClass();

		if (requestBeanClz == Object.class) {
			return interceptSelectOptionResource(selectOptionJsonConfigurer,
					this.doGetSelectOptionResource(request, null), null);
		}

		T requestBean = (T) HttpRequestToJavaBeanUtils.convertBean(request,
				requestBeanClz);

		request.setAttribute(requestBeanClz.getSimpleName(), requestBean);

		return interceptSelectOptionResource(selectOptionJsonConfigurer, this
				.doGetSelectOptionResource(request, requestBean), requestBean);
	}

	protected List interceptSelectOptionResource(
			SelectOptionJsonConfigurer selectOptionJsonConfigurer,
			List options, T parameterRequestBean) {

		return options;
	}

	protected abstract List doGetSelectOptionResource(
			HttpServletRequest request, T parameterRequestBean);

}
