package com.rapid.j2ee.framework.mvc.ui.json.select;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.anno.OptionAttribute;
import com.rapid.j2ee.framework.core.anno.OptionKey;
import com.rapid.j2ee.framework.core.anno.OptionMethodAttribute;
import com.rapid.j2ee.framework.core.anno.OptionMethodKey;
import com.rapid.j2ee.framework.core.anno.OptionMethodValue;
import com.rapid.j2ee.framework.core.anno.OptionValue;
import com.rapid.j2ee.framework.core.collections.HashMapAsKeyIgnoreCase;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.OperationResultConstants;
import com.rapid.j2ee.framework.mvc.ui.annotation.RequestResourceProvider;
import com.rapid.j2ee.framework.mvc.web.context.AbstractMvcMethodBodyContext;

public class SelectOptionResourceProviderFactory implements InitializingBean {

	public AbstractMvcMethodBodyContext<SelectOptionJsonConfigurer> getSelectOptionResourceForJson(
			AbstractMvcMethodBodyContext<SelectOptionJsonConfigurer> mvcMethodBodyContext,
			HttpServletRequest request) {

		SelectOptionJsonConfigurer selectOptionJsonConfigurer = new SelectOptionJsonConfigurer();

		List options = this.getSelectOptionResource(request
				.getParameter(SELECT_OPTION_RESOURCE_PROVIDER_NAME), request,
				selectOptionJsonConfigurer);

		if (TypeChecker.isEmpty(options)) {
			mvcMethodBodyContext.prepare(
					OperationResultConstants.SUCCESS_OPERATION,
					selectOptionJsonConfigurer);
			return mvcMethodBodyContext;
		}

		mvcMethodBodyContext.prepare(
				OperationResultConstants.SUCCESS_OPERATION,
				buildSelectOptionJsonConfigurer(selectOptionJsonConfigurer,
						options));

		return mvcMethodBodyContext;

	}

	private SelectOptionJsonConfigurer buildSelectOptionJsonConfigurer(
			SelectOptionJsonConfigurer selectOptionJsonConfigurer, List options) {

		Class optionClass = options.get(0).getClass();

		selectOptionJsonConfigurer.setOptionKeyName(getOptionName(optionClass,
				OptionKey.class, OptionMethodKey.class));

		selectOptionJsonConfigurer.setOptionValueName(getOptionName(
				optionClass, OptionValue.class, OptionMethodValue.class));

		selectOptionJsonConfigurer
				.setOptionAttributes(getOptionAttributeNames(optionClass,
						OptionAttribute.class, OptionMethodAttribute.class));

		selectOptionJsonConfigurer.setOptions(options);

		return selectOptionJsonConfigurer;

	}

	private String getOptionAttributeNames(Class optionClass,
			Class<? extends Annotation> fieldAttrAnnotation,
			Class<? extends Annotation> methodAttrAnnotation) {

		Field[] optionAttributeFields = ClassUtils.getFieldsByAnnotation(
				optionClass, fieldAttrAnnotation);

		List<String> attributes = new ArrayList<String>(CollectionsUtil
				.getListValuesByFieldName(String.class, Arrays
						.asList(optionAttributeFields), "name"));

		Method[] optionAttributeMethods = ClassUtils
				.getAllMethodsAsClassByAnnotation(optionClass,
						methodAttrAnnotation);

		for (Method method : optionAttributeMethods) {
			attributes.add(ClassUtils.getMethodNameWithoutGetterSetter(method
					.getName()));
		}

		return StringUtils.getStringBunch(attributes, ",").trim();

	}

	private String getOptionName(Class optionClass,
			Class<? extends Annotation> fieldAnnotation,
			Class<? extends Annotation> methodAnnotation) {
		Field field = ClassUtils.getFieldByAnnotation(optionClass,
				fieldAnnotation);
		if (!TypeChecker.isNull(field)) {
			return field.getName();
		}

		Method method = ClassUtils.getMethodAsClassByAnnotation(optionClass,
				methodAnnotation);

		if (!TypeChecker.isNull(method)) {

			return ClassUtils
					.getMethodNameWithoutGetterSetter(method.getName());
		}

		Assert.notNull(null);

		return null;
	}

	public List getSelectOptionResource(String providerName,
			HttpServletRequest request,
			SelectOptionJsonConfigurer selectOptionJsonConfigurer) {

		Assert.isTrue(selectOptionSourceProviderMapper
				.containsKey(providerName));

		AbstractSelectOptionResourceProvider abstractSelectOptionSourceProvider = (AbstractSelectOptionResourceProvider) selectOptionSourceProviderMapper
				.get(providerName);

		log.info("The select option resource provider class = "
				+ abstractSelectOptionSourceProvider.getClass()
				+ " under Provider name[" + providerName + "]");

		return abstractSelectOptionSourceProvider.getSelectOptionResource(
				request, abstractSelectOptionSourceProvider.getClass()
						.getAnnotation(RequestResourceProvider.class),
				selectOptionJsonConfigurer);

	}

	public void afterPropertiesSet() throws Exception {

		for (AbstractSelectOptionResourceProvider abstractSelectOptionSourceProvider : selectOptionSourceProviders) {

			Assert.isTrue(abstractSelectOptionSourceProvider.getClass()
					.isAnnotationPresent(RequestResourceProvider.class));

			RequestResourceProvider selectOptionResourceProvider = abstractSelectOptionSourceProvider
					.getClass().getAnnotation(RequestResourceProvider.class);

			log.info("SelectOptionResourceProvider Loading "
					+ selectOptionResourceProvider.value()
					+ " Implement Class:"
					+ abstractSelectOptionSourceProvider.getClass().getName());

			selectOptionSourceProviderMapper.put(selectOptionResourceProvider
					.value(), abstractSelectOptionSourceProvider);
		}
	}

	@Autowired(required = false)
	private List<AbstractSelectOptionResourceProvider> selectOptionSourceProviders = new ArrayList<AbstractSelectOptionResourceProvider>();

	private HashMapAsKeyIgnoreCase selectOptionSourceProviderMapper = new HashMapAsKeyIgnoreCase();

	private static final String SELECT_OPTION_RESOURCE_PROVIDER_NAME = "providerName";

	private Log log = LogFactory
			.getLog(SelectOptionResourceProviderFactory.class);

}
