package com.rapid.j2ee.framework.mvc.ui.taglib;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.components.Component;
import org.apache.struts2.views.jsp.ComponentTagSupport;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.mvc.ui.taglib.component.ScopeVariableComponent;

public class ScopeVariableComponentTag extends ComponentTagSupport {

	private static final long serialVersionUID = 1L;

	private String scope;

	private String var;

	private String parameter;

	private String readScope;

	public void setParameter(String parameter) {
		this.parameter = parameter;
	}

	public void setReadScope(String readScope) {
		this.readScope = readScope;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

	public void setVar(String var) {
		this.var = var;
	}

	public String getParameter() {
		return parameter;
	}

	public String getReadScope() {
		return readScope;
	}

	public String getScope() {
		return scope;
	}

	public String getVar() {
		return StringUtils.trimToEmpty(this.var, this.parameter);
	}

	@Override
	public Component getBean(ValueStack stack, HttpServletRequest request,
			HttpServletResponse response) {

		ScopeVariableComponent component = new ScopeVariableComponent(request,
				stack, this);

		return component;
	}
}
