package com.rapid.j2ee.framework.mvc.ui.taglib.component;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import org.apache.struts2.components.Component;
import org.apache.struts2.views.jsp.ComponentTagSupport;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.ui.taglib.CleanBeanTag;

public abstract class AbstractComponent extends Component {

	protected ComponentTagSupport componentTagSupport;

	public AbstractComponent(ValueStack stack,
			ComponentTagSupport componentTagSupport) {
		super(stack);
		this.componentTagSupport = componentTagSupport;
	}

	public final void write(Writer writer, String context) {

		try {
			writer.write(context);
		} catch (Exception e) {

		}
	}

	public final void writeln(Writer writer, String context) {
		try {
			writer.write(StringUtils.trimToEmpty(context));
			writer.write("\r\n");
		} catch (Exception e) {

		}
	}

	public final String findStringWithDefaultExp(String exp) {

		if (TypeChecker.isEmpty(exp)) {
			return exp;
		}

		String value = (String) super.findValue(exp);

		return StringUtils.trimToEmpty(value, exp);
	}

	public final List findValueList(String exp) {

		Object obj = this.findValueWithExpression(exp);

		if (TypeChecker.isNull(obj)) {
			return ObjectUtils.EMPTY_LIST;
		}

		if (obj instanceof List) {
			return (List) obj;
		}

		List rs = new ArrayList(1);

		rs.add(obj);

		return rs;
	}

	public String findValueStringWithExpression(String exp) {
		return String.valueOf(findValueWithExpression(exp));
	}

	public Object findValueWithExpression(String exp) {

		String[] expArgs = StringUtils.splitClosure(exp, "%{", "}");

		if (TypeChecker.isNull(expArgs)) {
			return super.findValue(exp);
		}

		if (expArgs.length == 1) {
			return super.findValue(expArgs[0]);
		}

		for (String expArg : expArgs) {

			Object value = super.findValue(expArg);

			exp = StringUtils.replace(exp, "%{" + expArg + "}", String
					.valueOf(value));
		}

		return exp;
	}

	public boolean start(Writer writer) {

		boolean gotoEndTag = true;
		try {
			gotoEndTag = doStart(writer);

		} catch (Throwable e) {

			if (componentTagSupport instanceof CleanBeanTag) {
				((CleanBeanTag) componentTagSupport).clear();
			}

			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {
			if (!gotoEndTag) {
				if (componentTagSupport instanceof CleanBeanTag) {
					((CleanBeanTag) componentTagSupport).clear();
				}
			}
		}

		return gotoEndTag;
	}

	protected boolean end(Writer writer, String body, boolean stack) {
		try {
			return this.doEnd(writer, body, stack);
		} catch (Throwable e) {

			throw ExceptionUtils.convertThrowableToBaseException(e);
		} finally {

			if (componentTagSupport instanceof CleanBeanTag) {
				((CleanBeanTag) componentTagSupport).clear();
			}
		}
	}

	protected abstract boolean doStart(Writer writer) throws Throwable;

	protected abstract boolean doEnd(Writer writer, String body, boolean stack)
			throws Throwable;

	protected final String getStyleAttribute(String name, String value) {
		if (TypeChecker.isEmpty(value)) {
			return "";
		}

		return " " + name + ":" + value + "; ";
	}

	protected final String getAttribute(String name, String value) {
		if (TypeChecker.isEmpty(value)) {
			return "";
		}

		return " " + name + "=\"" + value + "\" ";
	}

	protected final String getStyleAttributePx(String name, String value) {
		if (TypeChecker.isEmpty(value)) {
			return "";
		}

		return " " + name + ":" + value + "px; ";
	}

}
