package com.rapid.j2ee.framework.mvc.ui.taglib.component;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.ui.taglib.freemarker.AbstractFreemarkerComponentTag;

import freemarker.template.Template;

public abstract class AbstractFreemarkerComponent<T extends AbstractFreemarkerComponentTag>
		extends AbstractComponent {

	private Template template;

	private String templateHtmlContent;

	public AbstractFreemarkerComponent(Template template,
			T htmlFreemarkerComponentTag, ValueStack stack) {
		super(stack, htmlFreemarkerComponentTag);
		this.template = template;
	}

	@Override
	protected boolean doStart(Writer writer) throws Throwable {

		StringWriter sw = new StringWriter(1000);

		Map freemarkerRootMap = getResovledBeanPopulatedMap(
				(T) this.componentTagSupport, this.getBeanPopulatedMap());

		template.process(freemarkerRootMap, sw);

		sw.flush();
		sw.close();

		templateHtmlContent = sw.toString();

		return this.doStart(writer, templateHtmlContent);

	}

	protected abstract boolean doStart(Writer writer,
			String freeMarkerTemplateContent) throws Throwable;

	@Override
	protected boolean doEnd(Writer writer, String body, boolean stack)
			throws Throwable {

		try {
			if (TypeChecker.isEmpty(templateHtmlContent)) {
				return false;
			}

			this.doEnd(writer, templateHtmlContent, body, stack);

			return false;
		} finally {

			if (freemarkerTemplateParameters != null) {
				freemarkerTemplateParameters.clear();
				freemarkerTemplateParameters = null;
			}

			try {
				template = null;
			} catch (Exception e) {

			}
		}
	}

	protected abstract void doEnd(Writer writer,
			String freemarkerTemplateContent, String body, boolean stack)
			throws Throwable;

	protected final Map getBeanPopulatedMap() {

		if (freemarkerTemplateParameters == null) {
			freemarkerTemplateParameters = ((AbstractFreemarkerComponentTag) this.componentTagSupport)
					.getBeanPopulatedMap();
		}
		return freemarkerTemplateParameters;
	}

	protected Map getResovledBeanPopulatedMap(T htmlFreemarkerComponentTag,
			Map beanMap) {
		return beanMap;
	}

	private Map freemarkerTemplateParameters = null;
}
