package com.rapid.j2ee.framework.mvc.ui.taglib.component;

import java.io.Writer;
import java.util.Collection;

import org.apache.struts2.views.jsp.ComponentTagSupport;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.CollectionsUtil;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.ui.taglib.BeanTranslationComponentTag;

public class BeanTranslationComponent extends AbstractComponent {

	public BeanTranslationComponent(ValueStack stack,
			BeanTranslationComponentTag beanTagSupport) {

		super(stack, beanTagSupport);

		this.beanTagSupport = beanTagSupport;
	}

	@Override
	protected boolean doStart(Writer writer) throws Throwable {

		Object value = this.findValue(beanTagSupport.getValue());

		Collection collection = (Collection) this.findValue(this.beanTagSupport
				.getList());

		if (TypeChecker.isEmpty(collection)) {
			return false;
		}

		Object bean = CollectionsUtil.findOne(collection, beanTagSupport
				.getOptionKey(), value);

		if (TypeChecker.isNull(bean)) {
			return false;
		}

		value = BeanUtils.getProperty(bean, beanTagSupport.getOptionValue());

		if (TypeChecker.isNull(value)) {
			return false;
		}

		writer.write(StringUtils.trimToEmpty(String.valueOf(value)));

		return false;
	}

	@Override
	protected boolean doEnd(Writer writer, String body, boolean stack)
			throws Throwable {

		return false;
	}

	private BeanTranslationComponentTag beanTagSupport;

}
