package com.rapid.j2ee.framework.mvc.ui.taglib.component;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.mvc.ui.taglib.freemarker.FreemarkerConfigureComponentTag;

import freemarker.template.Template;

public class FreemarkerConfigureComponent extends AbstractComponent {

	public FreemarkerConfigureComponent(HttpServletRequest request,
			ValueStack stack,
			FreemarkerConfigureComponentTag freemarkerConfigureComponentTag) {
		super(stack, freemarkerConfigureComponentTag);

		this.request = request;

		template = freemarkerConfigureComponentTag.getTemplate(request);

	}

	@Override
	protected boolean doEnd(Writer writer, String body, boolean stack)
			throws Throwable {

		Map<String, Object> rootMap = (Map<String, Object>) request
				.getAttribute("FreemarkerConfigureComponent_Root");

		template.process(rootMap, writer);

		writer.flush();

		request.removeAttribute("FreemarkerConfigureComponent_Root");

		return true;
	}

	@Override
	protected boolean doStart(Writer writer) throws Throwable {

		request.setAttribute("FreemarkerConfigureComponent_Root",
				new HashMap<String, Object>(5));

		return true;
	}

	private HttpServletRequest request;

	private Template template;
}
