package com.rapid.j2ee.framework.mvc.ui.taglib.component;

import java.io.Writer;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.mvc.ui.taglib.freemarker.FreemarkerConfigureComponentParamTag;

public class FreemarkerConfigureComponentParam extends AbstractComponent {

	public FreemarkerConfigureComponentParam(
			HttpServletRequest request,
			ValueStack stack,
			FreemarkerConfigureComponentParamTag freemarkerConfigureRootItemComponentTag) {
		super(stack, freemarkerConfigureRootItemComponentTag);
		this.freemarkerConfigureRootItemComponentTag = freemarkerConfigureRootItemComponentTag;
		this.request = request;
	}

	@Override
	protected boolean doEnd(Writer writer, String body, boolean stack)
			throws Throwable {

		return true;
	}

	@Override
	protected boolean doStart(Writer writer) throws Throwable {

		Map<String, Object> freemarkRootMap = (Map<String, Object>) request
				.getAttribute("FreemarkerConfigureComponent_Root");

		if (!this.isOnglExpression(this.freemarkerConfigureRootItemComponentTag
				.getValue())) {
			freemarkRootMap.put(freemarkerConfigureRootItemComponentTag
					.getKey(), freemarkerConfigureRootItemComponentTag
					.getValue());

			return true;
		}

		freemarkRootMap.put(freemarkerConfigureRootItemComponentTag.getKey(),
				this.stack.findValue(freemarkerConfigureRootItemComponentTag
						.getValue()));

		return true;
	}

	private boolean isOnglExpression(String exp) {

		if (exp.indexOf("+") > 0) {

			return true;
		}

		return !exp.startsWith("'") && !exp.startsWith("\"");

	}

	private FreemarkerConfigureComponentParamTag freemarkerConfigureRootItemComponentTag;

	private HttpServletRequest request;

}
