package com.rapid.j2ee.framework.mvc.ui.taglib.component;

import java.io.Writer;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.mvc.ui.taglib.freemarker.AbstractFreemarkerComponentTag;

import freemarker.template.Template;

public class HtmlFreemarkerComponent extends AbstractFreemarkerComponent {

	private static final String Header_Footer_Separator_Line = "<!-- boundary -->";

	public HtmlFreemarkerComponent(Template template,
			AbstractFreemarkerComponentTag htmlFreemarkerComponentTag,
			ValueStack stack) {
		super(template, htmlFreemarkerComponentTag, stack);

	}

	@Override
	protected void doEnd(Writer writer, String freemarkerTemplateContent,
			String body, boolean stack) throws Throwable {

		writer.write(StringUtils.substringAfter(freemarkerTemplateContent,
				Header_Footer_Separator_Line));
	}

	@Override
	protected boolean doStart(Writer writer, String freeMarkerTemplateContent)
			throws Throwable {

		writer.write(StringUtils.substringBefore(freeMarkerTemplateContent,
				Header_Footer_Separator_Line));
		return true;

	}

}
