package com.rapid.j2ee.framework.mvc.ui.taglib.component;

import java.io.Writer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.views.jsp.ComponentTagSupport;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.spring.SpringPropertiesHolder;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.ui.taglib.component.AbstractComponent;

public class HtmlLabelComponent extends AbstractComponent {

	public HtmlLabelComponent(ValueStack stack,
			HtmlLabelComponentTag htmlLabelComponentTag) {
		super(stack, htmlLabelComponentTag);

	}

	@Override
	protected boolean doEnd(Writer writer, String body, boolean stack)
			throws Throwable {

		return false;
	}

	@Override
	protected boolean doStart(Writer writer) throws Throwable {

		HtmlLabelComponentTag htmlLabelComponentTag = (HtmlLabelComponentTag) this.componentTagSupport;

		String labelKey = htmlLabelComponentTag.getFunctionName() + "."
				+ super.findValue(htmlLabelComponentTag.getLabelType()) + "."
				+ htmlLabelComponentTag.getName();

		Log.info("Label Key:" + labelKey + " in labels.property");

		String labelName = SpringPropertiesHolder.getProperty(labelKey);

		boolean switchLabel = TypeChecker.isSpecialTrue(htmlLabelComponentTag
				.getSwitchLabel());

		if (!switchLabel) {

			writer.write(labelName);

			writer.flush();

			return false;
		}

		return !TypeChecker.isEmpty(labelName);
	}

	private static final Log Log = LogFactory.getLog(HtmlLabelComponent.class);
}
