package com.rapid.j2ee.framework.mvc.ui.taglib.component;

import java.io.Writer;
import java.util.List;

import org.apache.struts2.views.jsp.ComponentTagSupport;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.ui.taglib.JavascriptArrayComponentTag;

public class JavascriptArrayComponent extends AbstractComponent {

	private JavascriptArrayComponentTag javascriptArrayComponentTag;

	public JavascriptArrayComponent(ValueStack stack,
			ComponentTagSupport componentTagSupport) {
		super(stack, componentTagSupport);
		javascriptArrayComponentTag = (JavascriptArrayComponentTag) componentTagSupport;
	}

	private void writeArray(StringBuffer array, int index, Object item,
			String[] fields) {

		// 在声明二维
		array.append(javascriptArrayComponentTag.getName() + "[" + index
				+ "]=new Array();\n");

		for (int i = 0, j = fields.length; i < j; i++) {
			array.append(javascriptArrayComponentTag.getName() + "[" + index
					+ "][" + i + "]=\""
					+ BeanUtils.getProperty(item, fields[i]) + "\";");
			array.append("\n");
		}

	}

	/**
	 * var images=new array(); //先声明一维 for(var i=0;i<10;i++){ //一维长度为10
	 * images[i]=new array(); //在声明二维 for(var j=0;j<20;j++){ //二维长度为20
	 * images[i][j]=1; } }
	 */
	@Override
	protected boolean doStart(Writer writer) {

		List rs = findValueList(javascriptArrayComponentTag.getContext());

		String[] fields = StringUtils.splitBySeparators(
				javascriptArrayComponentTag.getFields(), ",", ";");

		if (TypeChecker.isEmpty(rs)) {
			write(writer, "var " + javascriptArrayComponentTag.getName()
					+ "=new Array();");

			return false;
		}

		if (TypeChecker.isSpecialTrue(javascriptArrayComponentTag
				.getScriptBody())) {
			writeln(writer, "<script>");
		}

		StringBuffer array = new StringBuffer(rs.size() * fields.length * 50);

		// 先声明一维
		array.append("var " + javascriptArrayComponentTag.getName()
				+ "=new Array();\n");

		for (int i = 0, j = rs.size(); i < j; i++) {
			Object item = rs.get(i);
			writeArray(array, i, item, fields);
		}

		write(writer, array.toString());

		if (TypeChecker.isSpecialTrue(javascriptArrayComponentTag
				.getScriptBody())) {
			writeln(writer, "</script>");
		}

		return false;
	}

	@Override
	protected boolean doEnd(Writer writer, String body, boolean stack)
			throws Throwable {

		return true;
	}

}
