package com.rapid.j2ee.framework.mvc.ui.taglib.component;

import java.io.Writer;

import javax.servlet.http.HttpServletRequest;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.mvc.ui.taglib.ScopeVariableComponentTag;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public class ScopeVariableComponent extends AbstractComponent {

	private ScopeVariableComponentTag scopeVariableComponentTag;

	private HttpServletRequest request;

	public ScopeVariableComponent(HttpServletRequest request, ValueStack stack,
			ScopeVariableComponentTag scopeVariableComponentTag) {
		super(stack, scopeVariableComponentTag);
		this.scopeVariableComponentTag = scopeVariableComponentTag;
		this.request = request;
	}

	@Override
	protected boolean doStart(Writer writer) {

		setAtributeValue(getObjectValueOnReadScope());

		return false;
	}

	private final void setAtributeValue(Object value) {

		if ("session".equalsIgnoreCase(scopeVariableComponentTag.getScope())) {
			ActionContextUtils.getHttpSession(this.request).setAttribute(
					scopeVariableComponentTag.getVar(), value);
			return;
		}
		if ("application"
				.equalsIgnoreCase(scopeVariableComponentTag.getScope())) {
			ActionContextUtils.getHttpSession(this.request).getServletContext()
					.setAttribute(scopeVariableComponentTag.getVar(), value);
			return;
		}

		this.request.setAttribute(scopeVariableComponentTag.getVar(), value);

	}

	private final Object getObjectValueOnReadScope() {

		String scope = scopeVariableComponentTag.getScope();

		String parameter = scopeVariableComponentTag.getParameter();

		if ("session".equalsIgnoreCase(scope)) {

			return ActionContextUtils.getHttpSession(this.request)
					.getAttribute(parameter);
		}
		if ("application".equalsIgnoreCase(scope)) {

			return ActionContextUtils.getHttpSession(this.request)
					.getServletContext().getAttribute(parameter);
		}
		if ("actionContext".equalsIgnoreCase(scope)) {

			if (parameter.startsWith("%{") && parameter.endsWith("}")) {

				parameter = (String) super.findValue(StringUtils.remove(
						parameter, "%{", "}"));

			}

			return super.findValue(parameter);
		}

		return this.request.getAttribute(parameter);
	}

	@Override
	protected boolean doEnd(Writer writer, String body, boolean stack)
			throws Throwable {

		return true;
	}
}
