package com.rapid.j2ee.framework.mvc.ui.taglib.component.tree;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.mvc.ui.taglib.component.GeneralFreemarkerComponent;
import com.rapid.j2ee.framework.mvc.ui.taglib.freemarker.tree.TreeFreemarkerComponentTag;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

import freemarker.template.Template;

@SuppressWarnings("unchecked")
public class TreeFreemarkerComponent extends
		GeneralFreemarkerComponent<TreeFreemarkerComponentTag> {

	private HttpServletRequest request;

	public TreeFreemarkerComponent(HttpServletRequest request,
			Template template,
			TreeFreemarkerComponentTag htmlFreemarkerComponentTag,
			ValueStack stack) {
		super(template, htmlFreemarkerComponentTag, stack);
		this.request = request;

	}

	@Override
	protected Map getResovledBeanPopulatedMap(
			TreeFreemarkerComponentTag htmlFreemarkerComponentTag, Map beanMap) {

		Map<String, Object> root = new HashMap<String, Object>(
				beanMap.size() + 5);

		TreeNodesAllocation treeNodeAllc = new TreeNodesAllocation(this
				.findValueList(htmlFreemarkerComponentTag.getSource()));

		treeNodeAllc.allocateTreeNodeByLevel();

		root.put("treeRoot", treeNodeAllc
				.getRootTreeNodes(htmlFreemarkerComponentTag.getRoot()));

		root.put("treeNodes", treeNodeAllc.getAllocatedMapByParentCode());

		root.put("contextPath", request.getContextPath());

		root
				.put("version", String.valueOf(ActionContextUtils
						.getFileVersion()));

		root.putAll(beanMap);

		return root;

	}

}
