package com.rapid.j2ee.framework.mvc.ui.taglib.component.tree;

import java.util.List;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

@SuppressWarnings("unchecked")
public class TreeNodeElement implements TreeNode {

	private List<TreeNode> childrens = ObjectUtils.EMPTY_LIST;

	private TreeNode source;

	public TreeNodeElement(TreeNode source) {
		this.source = source;
	}

	public List<TreeNode> getChildrens() {
		return this.childrens;
	}

	public void setChildrens(List<TreeNode> treeNodes) {

		if (TypeChecker.isEmpty(treeNodes)) {
			return;
		}

		childrens = treeNodes;
	}

	public String getNodeCode() {

		return source.getNodeCode();
	}

	public int getNodeLevel() {

		return source.getNodeLevel();
	}

	public String getNodeName() {

		return source.getNodeName();
	}

	public String getParentCode() {

		return source.getParentCode();
	}

	public boolean isNodeAuthorized() {

		return source.isNodeAuthorized();
	}

	public TreeNode getSource() {
		return this.source;
	}
}
