package com.rapid.j2ee.framework.mvc.ui.taglib.component.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public class TreeNodesAllocation {

	private List<TreeNodeElement> nodes;

	private Map<String, List<TreeNodeElement>> allocatedMaps = null;

	public TreeNodesAllocation(List<TreeNode> nodes) {
		this.nodes = getTreeNodeElements(nodes);
		allocatedMaps = new HashMap<String, List<TreeNodeElement>>(5);
	}

	private List<TreeNodeElement> getTreeNodeElements(List<TreeNode> sourceNodes) {

		List<TreeNodeElement> treeNodeElements = new ArrayList<TreeNodeElement>(
				sourceNodes.size());

		for (TreeNode treeNode : sourceNodes) {
			treeNodeElements.add(new TreeNodeElement(treeNode));
		}

		return treeNodeElements;
	}

	public void allocateTreeNodeByLevel() {

		for (TreeNodeElement node : nodes) {
			putTreeNodeToMapByParentCode(node);
		}

	}

	public Map<String, List<TreeNodeElement>> getAllocatedMapByParentCode() {
		return allocatedMaps;
	}

	public List<TreeNodeElement> getRootTreeNodes(String rootTagName) {

		List<TreeNodeElement> root = allocatedMaps.get(rootTagName);

		return TypeChecker.isEmpty(root) ? ObjectUtils.EMPTY_LIST : root;
	}

	private void putTreeNodeToMapByParentCode(TreeNodeElement node) {

		if (!allocatedMaps.containsKey(node.getParentCode())) {
			allocatedMaps.put(node.getParentCode(),
					new ArrayList<TreeNodeElement>(5));
		}

		allocatedMaps.get(node.getParentCode()).add(node);
	}

}
