package com.rapid.j2ee.framework.mvc.ui.taglib.freemarker;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.components.Component;
import org.apache.struts2.views.jsp.ComponentTagSupport;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.reflect.BeanUtils;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.mvc.ui.freemarker.FreemarkerConfigurer;
import com.rapid.j2ee.framework.mvc.ui.taglib.InitializingBeanTag;

import freemarker.template.Template;

public abstract class AbstractFreemarkerComponentTag extends
		ComponentTagSupport {

	private String templateDir = "";

	private String theme = "";

	private String template = "";

	public AbstractFreemarkerComponentTag() {

		templateDir = FreemarkerConfigurer.getParameter(
				"Freemarker.TemplateDir", "WEB-INF/template");

		theme = FreemarkerConfigurer
				.getParameter("Freemarker.Theme", "custome");
	}

	public String getDirectoryForTemplateLoading() {
		return FileUtils.getFullFilePathName(templateDir, theme);
	}

	public String getTemplate() {
		return template;
	}

	public void setTemplate(String template) {
		this.template = template;
	}

	public String getTemplateDir() {
		return templateDir;
	}

	public void setTemplateDir(String templateDir) {
		this.templateDir = templateDir;
	}

	public String getTheme() {
		return theme;
	}

	public void setTheme(String theme) {
		this.theme = theme;
	}

	public Template getTemplate(HttpServletRequest request) {
		try {
			return FreemarkerConfigurer.getConfiguration(
					getDirectoryForTemplateLoading())
					.getTemplate(this.template);

		} catch (Exception e) {

			System.out.println("Eror Template Folder =========== "
					+ getDirectoryForTemplateLoading() + " Template:"
					+ template);

			throw ExceptionUtils.convertThrowableToBaseException(e);
		}
	}

	@Override
	public Component getBean(ValueStack stack, HttpServletRequest request,
			HttpServletResponse response) {

		if (this instanceof InitializingBeanTag) {
			((InitializingBeanTag) this).afterPropertiesSet(request, stack);
		}

		return this.doGetBean(stack, request, response);
	}

	protected abstract Component doGetBean(ValueStack stack,
			HttpServletRequest request, HttpServletResponse response);

	public Map getBeanPopulatedMap() {
		return BeanUtils.getBeanPopulatedMap(this);
	}

}
