package com.rapid.j2ee.framework.mvc.ui.taglib.freemarker;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.components.Component;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.ui.taglib.CleanBeanTag;
import com.rapid.j2ee.framework.mvc.ui.taglib.component.HtmlFreemarkerComponent;

public class HtmlFreemarkerComponentTag extends AbstractFreemarkerComponentTag
		implements CleanBeanTag {

	private String name = "";

	private String cssClass = "";

	private String cssStyle = "";

	private String width = "";

	private String height = "";

	public String getCssClass() {
		return cssClass;
	}

	public String getCssStyle() {
		return cssStyle;
	}

	public String getName() {
		return name;
	}

	@Override
	protected Component doGetBean(ValueStack stack, HttpServletRequest request,
			HttpServletResponse response) {

		if (!TypeChecker.isEmpty(this.width)) {
			this.setCssStyle(this.getCssStyle() + ";width:" + this.getWidth()
					+ "px;");
		}

		if (!TypeChecker.isEmpty(this.height)) {
			this.setCssStyle(this.getCssStyle() + ";height:" + this.getHeight()
					+ "px;");
		}

		/**
		 * Template template, AbstractFreemarkerComponentTag
		 * htmlFreemarkerComponentTag, HttpServletRequest request, ValueStack
		 * stack
		 */
		return new HtmlFreemarkerComponent(this.getTemplate(request), this, stack);
	}

	public void clear() {
		this.name = "";
		this.cssClass = "";
		this.cssStyle = "";
		this.setTemplate("");
		this.setId("");
		this.height = "";
		this.width = "";
	}

	public void setCssClass(String cssClass) {
		this.cssClass = cssClass;
	}

	public void setCssStyle(String cssStyle) {
		this.cssStyle = cssStyle;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getHeight() {
		return height;
	}

	public void setHeight(String height) {
		this.height = height;
	}

	public String getWidth() {
		return width;
	}

	public void setWidth(String width) {
		this.width = width;
	}

	private static final long serialVersionUID = 1L;

}
