package com.rapid.j2ee.framework.mvc.ui.taglib.freemarker.divcomponent;

import javax.servlet.http.HttpServletRequest;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.utils.FileUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.ui.taglib.InitializingBeanTag;
import com.rapid.j2ee.framework.mvc.ui.taglib.freemarker.HtmlFreemarkerComponentTag;

public class DivContainerFreemarkerComponentTag extends
		HtmlFreemarkerComponentTag implements InitializingBeanTag {

	public DivContainerFreemarkerComponentTag() {
		super();
		this.setTheme(FileUtils.getFullFilePathName(this.getTheme(),
				"divcomponent"));

	}

	public void afterPropertiesSet(HttpServletRequest request, ValueStack stack) {

		this.setTemplate("divcontainerpopbasic.ftl");

		if (TypeChecker.isEmpty(this.getCssClass())) {
			this.setCssClass("DivContainer_PopBasic");
		} else {
			this.setCssClass("DivContainer_" + this.getCssClass());
		}

		request.setAttribute("DivContainer.Template", this.getTemplate());

		request.setAttribute("DivContainer.Theme", this.getTheme());

		request.setAttribute("DivContainer.cssClass", this.getCssClass());

		request.setAttribute("DivContainer.Id", StringUtils.trimToEmpty(this
				.getId()));
		request.setAttribute("DivContainer.Name", StringUtils.trimToEmpty(this
				.getName()));

	}

	private static final long serialVersionUID = 1L;

}
