package com.rapid.j2ee.framework.mvc.ui.taglib.freemarker.divcomponent;

import javax.servlet.http.HttpServletRequest;

import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;

public abstract class DivContainerInnerFreemarkerComponentTag extends
		DivContainerFreemarkerComponentTag {

	@Override
	public void afterPropertiesSet(HttpServletRequest request, ValueStack stack) {

		this.setCssClass(this.getFieldAttribute(request, "cssClass") + "_"
				+ this.getInnerType() + " " + this.getCssClass());

		this.setId(this.getFieldAttributeWithInnerType(this.getId(), request,
				"Id"));

		this.setName(this.getFieldAttributeWithInnerType(this.getName(),
				request, "Name"));

		if (TypeChecker.isEmpty(this.getTemplate())) {

			String template = this.getFieldAttribute(request, "Template");

			this.setTemplate(StringUtils.substringBeforeLast(template, ".")
					+ "_" + this.getInnerType().toLowerCase() + "."
					+ StringUtils.substringAfterLast(template, "."));
		}

	}

	protected final String getFieldAttributeWithInnerType(String childValue,
			HttpServletRequest request, String attributeName) {
		String fieldValue = this.getFieldAttribute(childValue, request,
				attributeName);
		return TypeChecker.isEmpty(fieldValue) ? "" : fieldValue + "_"
				+ this.getInnerType();
	}

	protected final String getFieldAttribute(String childValue,
			HttpServletRequest request, String attributeName) {

		if (!TypeChecker.isEmpty(childValue)) {
			return childValue;
		}

		return getFieldAttribute(request, attributeName);

	}

	protected final String getFieldAttribute(HttpServletRequest request,
			String attributeName) {

		return StringUtils.trimToEmpty((String) request
				.getAttribute("DivContainer." + attributeName));

	}

	protected abstract String getInnerType();

	private static final long serialVersionUID = 1L;

}
