package com.rapid.j2ee.framework.mvc.utils;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.fileupload.FileUploadThreadLocal;
import org.apache.commons.lang.ClassUtils;
import org.apache.struts2.ServletActionContext;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.ValueStack;
import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.ViewerType;
import com.rapid.j2ee.framework.mvc.security.logger.TraceMethodParameterNames;
import com.rapid.j2ee.framework.mvc.web.MvcBaseActionSupport;
import com.rapid.j2ee.framework.mvc.web.MvcBaseActionSupportContainer;
import com.rapid.j2ee.framework.mvc.web.annotation.MethodDownloadResource;
import com.rapid.j2ee.framework.mvc.web.annotation.ModelDriven;
import com.rapid.j2ee.framework.mvc.web.annotation.MvcMethodConfigurer;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContext;
import com.rapid.j2ee.framework.mvc.webservice.MvcWebServiceActionSupport;

public final class ActionContextUtils {

	private static long File_Version = System.currentTimeMillis();

	public static long getFileVersion() {
		return File_Version;
	}

	public static void setFileVersion(long fileVersion) {
		File_Version = fileVersion;
	}

	public static File getServletContextTempDir() {
		return (File) getServletContext().getAttribute(
				"javax.servlet.context.tempdir");

	}

	public static boolean existsActionContext() {
		try {
			return ActionContext.getContext() != null;
		} catch (Exception e) {
			return false;
		}
	}

	public static String getRequestHeader(String name) {
		return getRequestHeader(ActionContextUtils.getHttpRequest(), name);
	}

	public static String getRequestHeader(HttpServletRequest request,
			String name) {

		String headerValue = request.getHeader(name);

		if (!TypeChecker.isEmpty(headerValue)) {
			return headerValue;
		}

		headerValue = request.getHeader(name.toUpperCase());

		if (!TypeChecker.isEmpty(headerValue)) {
			return headerValue;
		}

		Enumeration<String> headerEnums = request.getHeaderNames();

		for (String headerName = null; headerEnums.hasMoreElements();) {
			headerName = headerEnums.nextElement();

			if (StringUtils.equalsIgnoreCase(headerName, name)) {
				return request.getHeader(headerName);
			}
		}

		return "";

	}

	public static boolean isBeforeLoginStage() {
		Boolean status = (Boolean) ActionContext.getContext().get(
				"ActionContextUtils.BeforeLoginStage");
		return TypeChecker.isNull(status) ? Boolean.FALSE : status
				.booleanValue();
	}

	public static void setBeforeLoginStage() {
		ActionContext.getContext().put("ActionContextUtils.BeforeLoginStage",
				true);
	}

	public static String getHttpParameter(String name, String... defValue) {

		if (getParameters().containsKey(name)) {

			Object value = getParameters().get(name);

			if (value instanceof String[]) {
				return StringUtils.trimToArrayEmpty(StringUtils
						.getFirstItemVoidEmptyInArrays((String[]) value),
						defValue);
			}

			if (value instanceof String) {

				return StringUtils.trimToArrayEmpty((String) value, defValue);
			}

		}

		if (!(ActionContextUtils.getRequest().get(name) instanceof String)) {
			return StringUtils.trimToArrayEmpty(StringUtils.trimToArrayEmpty(
					String.valueOf(ActionContextUtils.getRequest().get(name)),
					getHttpRequest().getParameter(name), FileUploadThreadLocal
							.getInstance().getParameter(name)), defValue);
		}

		return StringUtils.trimToArrayEmpty(StringUtils.trimToArrayEmpty(
				(String) ActionContextUtils.getRequest().get(name),
				getHttpRequest().getParameter(name), FileUploadThreadLocal
						.getInstance().getParameter(name)), defValue);
	}

	public static Map<String, Object> getParameters() {
		return ActionContext.getContext().getParameters();
	}

	public static Map getRequest() {
		return (Map) ActionContext.getContext().get("request");
	}

	public static Map<String, Object> getSession() {

		return (Map<String, Object>) ActionContext.getContext().getSession();
	}

	public static Map<String, Object> getApplication() {
		return (Map<String, Object>) ActionContext.getContext()
				.getApplication();
	}

	public static HttpServletRequest getHttpRequest() {

		HttpServletRequest request = ServletActionContext.getRequest();

		Assert.notNull(request, "Cannot Read Http Servlet Request!!!");

		return request;

	}

	public static Map<String, String> getHttpRequestParameterProperties() {

		Enumeration<String> enums = getHttpRequest().getParameterNames();

		Map<String, String> request = new HashMap<String, String>();

		for (; enums.hasMoreElements();) {
			String key = enums.nextElement();
			request.put(key, getHttpParameter(key, ""));
		}

		return request;
	}

	public static HttpSession getHttpSession() {

		return getHttpSession(getHttpRequest());

	}

	public static HttpSession getHttpSession(HttpServletRequest request) {
		if (TypeChecker.isNull(request)) {
			return null;
		}

		HttpSession session = request.getSession();

		if (TypeChecker.isNull(session)) {
			session = request.getSession(true);
		}
		return session;
	}

	public static HttpServletResponse getHttpResponse() {
		return ServletActionContext.getResponse();
	}

	public static ServletContext getServletContext() {
		return ServletActionContext.getServletContext();
	}

	public static String getContextRootRealPath() {
		return getServletContext().getRealPath("/");
	}

	public static WebApplicationContext getWebApplicationContext() {
		return WebApplicationContextUtils
				.getWebApplicationContext(getServletContext());
	}

	public static void setActionModel(Object model) {
		ActionContext.getContext().put("ActionContextUtils.ActionModel", model);
	}

	public static boolean isActionModelClass(Class clz) {

		Object model = getActionModel();

		if (TypeChecker.isNull(model)) {
			return false;
		}

		return clz == model.getClass()
				|| ClassUtils.isAssignable(model.getClass(), clz);

	}

	public static Object getActionModel() {
		return ActionContext.getContext().get("ActionContextUtils.ActionModel");
	}

	public static Class getActionClass() {
		return (Class) ActionContext.getContext().get(
				"ActionContextUtils.ActionClass");
	}

	public static ActionContext getStrutActionContext() {
		return ActionContext.getContext();
	}

	public static void setActionThrowable(Exception throwable) {
		ActionContext.getContext().put("ActionContextUtils.ActionError",
				throwable);
	}

	public static Exception getActionThrowable() {
		return (Exception) ActionContext.getContext().get(
				"ActionContextUtils.ActionError");
	}

	public static boolean hasActionError() {
		return !TypeChecker.isNull(getActionThrowable());
	}

	public static void setActionClass(Class action) {

		ActionContext.getContext()
				.put("ActionContextUtils.ActionClass", action);
	}

	public static String getActionMethodName() {
		return (String) ActionContext.getContext().get(
				"ActionContextUtils.ActionMethodName");
	}

	public static void setActionMethodName(String methodName) {
		ActionContext.getContext().put("ActionContextUtils.ActionMethodName",
				methodName);
	}

	public static void setActionMethod(Method method) {
		ActionContext.getContext().put("ActionContextUtils.ActionMethod",
				method);
		setMethodTraceParameterNames(method);
	}

	public static String getMethodTraceParameterNames() {
		return (String) ActionContext.getContext().get("TraceParameterNames");
	}

	public static void setMethodTraceParameterNames(Method method) {

		if (!method.isAnnotationPresent(TraceMethodParameterNames.class)) {
			return;
		}

		ActionContext.getContext().put(
				"TraceParameterNames",
				method.getAnnotation(TraceMethodParameterNames.class)
						.parameterNames());

	}

	public static Method getActionMethod() {
		return (Method) ActionContext.getContext().get(
				"ActionContextUtils.ActionMethod");
	}

	public static boolean isMethodDownloadResourceMode() {

		if (TypeChecker.isNull(getActionMethod())) {
			return false;
		}

		return !TypeChecker.isNull(getActionMethod().getAnnotation(
				MethodDownloadResource.class));
	}

	// MvcMethod

	public static Class getModelDrivenClassByAnnotation() {

		Method method = getActionMethod();

		if (TypeChecker.isNull(method)) {
			return null;
		}

		for (Class clz : ActionContextUtils.getActionMethod()
				.getParameterTypes()) {

			if (clz.isAnnotationPresent(ModelDriven.class)) {

				Class realModelDrivenClz = ((ModelDriven) clz
						.getAnnotation(ModelDriven.class)).value();

				if (Object.class == realModelDrivenClz) {
					return clz;
				}

				return realModelDrivenClz;
			}
		}

		return null;
	}

	public static MvcMethodConfigurer getMvcMethodConfigurer() {
		return (MvcMethodConfigurer) ActionContext.getContext().get(
				"ActionContextUtils.MvcMethodConfigurer");
	}

	public static void setMvcMethodConfigurer(MvcMethodConfigurer mvcMethod) {
		ActionContext.getContext().put(
				"ActionContextUtils.MvcMethodConfigurer", mvcMethod);
	}

	public static ViewerType getViewerType() {

		if (TypeChecker.isNull(getMvcMethodConfigurer())) {
			return ViewerType.Html;
		}

		ViewerType type = getMvcMethodConfigurer().type();

		if (MvcWebServiceActionSupport.class
				.isAssignableFrom(ActionContextUtils.getActionClass())) {
			if (type == ViewerType.ByRequest
					&& TypeChecker.isEmpty(ActionContextUtils
							.getHttpParameter(type.getViewType()))) {
				return ViewerType.Xml;
			}
		}

		return type == ViewerType.ByRequest ? ViewerType
				.getViewerType(ActionContextUtils.getHttpParameter(type
						.getViewType())) : type;
	}

	public static MvcMethodContext getMvcMethodContext() {
		return (MvcMethodContext) ActionContext.getContext().get(
				"ActionContextUtils.MvcMethodContext");
	}

	public static void setMvcMethodContext(MvcMethodContext context) {
		ActionContext.getContext().put("ActionContextUtils.MvcMethodContext",
				context);
	}

	public static void setBrowserCharset(
			MvcBaseActionSupportContainer mvcBaseActionSupportContainer) {
		ActionContext.getContext().put("ActionContextUtils.BrowserCharset",
				mvcBaseActionSupportContainer.getBrowserCharset());
	}

	public static String getBrowserCharset() {
		return StringUtils.trimToEmpty((String) ActionContext.getContext().get(
				"ActionContextUtils.BrowserCharset"), Charsets
				.getCharsetInstance(CharsetType.UTF_8).getCharset());
	}

	public static MvcBaseActionSupport getMvcBaseActionSupport() {
		return (MvcBaseActionSupport) ActionContext.getContext().get(
				"ActionContextUtils.getMvcBaseActionSupport");
	}

	public static void setMvcBaseActionSupport(
			MvcBaseActionSupport mvcBaseActionSupport) {
		ActionContext.getContext().put(
				"ActionContextUtils.getMvcBaseActionSupport",
				mvcBaseActionSupport);
	}

	public static void setResultMvcMethodContext(Result result) {
		setMvcMethodContext(result.getMvcMethodGeneralBodyContext());
	}

	public static ValueStack getValueStack() {
		return (ValueStack) ActionContextUtils.getHttpRequest().getAttribute(
				"struts.valueStack");
	}

	public static Object findValue(String exp) {

		if (TypeChecker.isEmpty(exp) || getValueStack() == null) {
			return exp;
		}

		exp = StringUtils.splitClosure(exp, "%{", "}")[0];

		return getValueStack().findValue(exp);
	}

	public static String findStringAtValueStack(String exp) {

		if (TypeChecker.isEmpty(exp) || getValueStack() == null) {
			return exp;
		}

		for (String key : StringUtils.splitClosure(exp, "%{", "}")) {
			exp = StringUtils.replace(exp, "%{" + key + "}", StringUtils
					.trimObjectToEmpty(getValueStack().findValue(key)));
		}

		return exp;
	}

	private ActionContextUtils() {

	}
}
