package com.rapid.j2ee.framework.mvc.utils;

import com.rapid.j2ee.framework.mvc.constants.OperationResult;
import com.rapid.j2ee.framework.mvc.constants.OperationResultConstants;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodGeneralBodyContext;

public class Result<T> implements java.io.Serializable {

	private static final long serialVersionUID = 1L;

	private OperationResult operationResult = OperationResultConstants.SUCCESS_OPERATION;

	private T result;

	private Object[] resultMessageArguments;

	public Object[] getResultMessageArguments() {
		return resultMessageArguments;
	}

	public void setResultMessageArguments(Object... resultMessageArguments) {
		this.resultMessageArguments = resultMessageArguments;
	}

	private Result(OperationResult operationResult, T result) {
		this.result = result;
		this.operationResult = operationResult;
	}

	public static Result getResult(OperationResult operationResult,
			Object result) {
		return new Result(operationResult, result);
	}

	public static Result getSuccessResult(Object result) {
		return new Result(OperationResultConstants.SUCCESS_OPERATION, result);
	}

	public static Result getResult(OperationResult operationResult) {
		return getResult(operationResult, Default_Result_Object);
	};

	public OperationResult getOperationResult() {
		return operationResult;
	}

	public T getResult() {
		return result;
	}

	public boolean isSuccess() {
		return this.operationResult.isSuccess();
	}

	public MvcMethodGeneralBodyContext<T> getMvcMethodGeneralBodyContext() {

		MvcMethodGeneralBodyContext<T> mvcMethodGeneralBodyContext = new MvcMethodGeneralBodyContext<T>();
		mvcMethodGeneralBodyContext.prepare(operationResult, this.result);
		mvcMethodGeneralBodyContext
				.setResultMessageArguments(resultMessageArguments);

		return mvcMethodGeneralBodyContext;
	}

	private static final Object Default_Result_Object = new Object();
}
