package com.rapid.j2ee.framework.mvc.utils;

import java.io.Serializable;

import com.rapid.j2ee.framework.mvc.constants.OperationResult;

public class StreamResult implements Serializable {

	private static final long serialVersionUID = -3389090851671756102L;

	private String code;

	private String message;

	public StreamResult(String code, String message) {
		this.code = code;
		this.message = message;
	}

	public String getCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}

	public boolean isSuccess() {
		return String.valueOf(OperationResult.Success).equals(this.code);
	}

	public boolean isDataNotFound() {
		return String.valueOf(OperationResult.NoData_Warning).equals(this.code);
	}
}
