package com.rapid.j2ee.framework.mvc.web;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;

import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.interceptor.ValidationWorkflowAware;
import com.rapid.j2ee.framework.bean.assemble.BeanAssembleFactory;
import com.rapid.j2ee.framework.bean.requestbeans.RequestBeansAssembleFactory;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.exception.SystemException;
import com.rapid.j2ee.framework.core.io.xml.XPathParser;
import com.rapid.j2ee.framework.core.reflect.ConstructorUtils;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.utils.ActionContext;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.NumberUtils;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.PropertiesUtils;
import com.rapid.j2ee.framework.core.utils.ResponseUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.SupportActionConstants;
import com.rapid.j2ee.framework.mvc.constants.ViewerType;
import com.rapid.j2ee.framework.mvc.exception.UploadFileExcceedLimitationApplicationException;
import com.rapid.j2ee.framework.mvc.exception.UploadFileNotAllowTypeApplicationException;
import com.rapid.j2ee.framework.mvc.i18n.I18NMessageFormat;
import com.rapid.j2ee.framework.mvc.security.domain.WebUser;
import com.rapid.j2ee.framework.mvc.security.utils.MvcSecurityActionContextUtils;
import com.rapid.j2ee.framework.mvc.ui.fieldstyle.AbstractUIHtmlFieldStyleSettingsController;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;
import com.rapid.j2ee.framework.mvc.web.annotation.InitPageParameter;
import com.rapid.j2ee.framework.mvc.web.annotation.MethodHttpParametersClass;
import com.rapid.j2ee.framework.mvc.web.annotation.MethodHttpParametersClassIterator;
import com.rapid.j2ee.framework.mvc.web.annotation.MethodParameter;
import com.rapid.j2ee.framework.mvc.web.annotation.MethodUserRequest;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContext;
import com.rapid.j2ee.framework.mvc.web.i18n.I18NMessageMvcMethodContext;
import com.rapid.j2ee.framework.mvc.web.text.MvcMethodContextFormatTextResolver;

public abstract class MvcBaseActionSupport extends
		MvcBaseActionSupportContainer implements ModelDriven,
		ValidationWorkflowAware {

	@Override
	public void validate() {

		hasMvcMethodContextError = false;

		// doCheckAndHandeActionErrorBeforeValidate();

		Method method = InvokeUtils.getMethod(this.getClass(),
				ActionContextUtils.getActionMethodName() + "Validate", null,
				SupportActionConstants.Action_Invoke_Perfix_Method_Names, true);

		if (TypeChecker.isNull(method)) {
			doCheckAndHandeActionErrorAfterValidate();
			return;
		}

		Object returnValue = this.invokeMethod(method);

		hasMvcMethodContextError = this.hasMvcMethodContextError();

		if (!hasMvcMethodContextError) {
			doCheckAndHandeActionErrorAfterValidate();
		}

		if (returnValue instanceof String) {
			pageIndicator = (String) returnValue;
		}

	}

	protected void doCheckAndHandeActionErrorAfterValidate() {

		if (!this.hasErrors()) {
			return;
		}

		String errorInfo = "Validate Error!"
				+ String.valueOf(this.getActionErrors())
				+ String.valueOf(this.getFieldErrors());

		if (this.hasActionErrors()) {

			for (String actionError : this.getActionErrors()) {

				if (actionError
						.startsWith(SupportActionConstants.SupportAction_Error_FileSize_Excceed_Limit_Message)) {
					throw new UploadFileExcceedLimitationApplicationException(
							errorInfo);
				}

			}

		}

		if (this.hasFieldErrors()) {

			for (String fieldName : this.getFieldErrors().keySet()) {
				for (String fieldMessage : this.getFieldErrors().get(fieldName)) {

					if (fieldMessage
							.contains(SupportActionConstants.SupportAction_Field_Error_FileSize_Excceed_Limit_Message)) {

						throw new UploadFileExcceedLimitationApplicationException(
								errorInfo)
								.setResultMessageArguments(StringUtils
										.splitBySeparator(fieldMessage, " "));
					}

					if (fieldMessage
							.contains(SupportActionConstants.SupportAction_Field_Error_FileType_NotAllow_Message)) {

						throw new UploadFileNotAllowTypeApplicationException(
								errorInfo)
								.setResultMessageArguments(StringUtils
										.splitBySeparator(fieldMessage, " "));
					}

					// Content-Type not allowed:
				}
			}
		}

		throw new SystemException(errorInfo);

	}

	@Override
	public String execute() throws Exception {

		if (hasMvcMethodContextError) {

			this.doWriteMvcMethodContextToResponse(ActionContextUtils
					.getMvcMethodContext());

			return null;
		}

		this.doInitMethodGlabolParameters();

		if (ActionContextUtils.hasActionError()) {
			throw ActionContextUtils.getActionThrowable();
		}

		Object returnValue = this.invokeMethod(ActionContextUtils
				.getActionMethod());

		if (ActionContextUtils.isMethodDownloadResourceMode()) {
			return null;
		}

		this.doProcessReturnValue(returnValue);

		if (this.doWriteMvcMethodContextToResponse(ActionContextUtils
				.getMvcMethodContext())) {
			return null;
		}

		if (returnValue instanceof String) {

			uiHtmlFieldStyleSettingsController
					.autoHtmlFieldStyleSettingsForHiddenView();

			return (String) returnValue;
		}

		return null;
	}

	private boolean hasMvcMethodContextError() {

		MvcMethodContext mvcMethodContext = ActionContextUtils
				.getMvcMethodContext();

		return !TypeChecker.isNull(mvcMethodContext)
				&& !mvcMethodContext.isResultSuccess();
	}

	protected final void doProcessReturnValue(Object returnValue) {

		if (TypeChecker.isNull(returnValue)) {
			return;
		}

		if (returnValue instanceof MvcMethodContext) {
			ActionContextUtils
					.setMvcMethodContext((MvcMethodContext) returnValue);
		}

	}

	public boolean doWriteMvcMethodContextToResponse(
			MvcMethodContext mvcMethodContext) {

		if (TypeChecker.isNull(mvcMethodContext)) {
			return false;
		}

		// 国际化Message in MvcMethodContext
		I18NMessageMvcMethodContext.toI18NMessage(i18nMessageFormat,
				mvcMethodContext);

		return this.doWriteMvcMethodContextToResponseByViewType(
				ActionContextUtils.getViewerType(), mvcMethodContext);

	}

	protected boolean doWriteMvcMethodContextToResponseByViewType(
			ViewerType viewerType, MvcMethodContext mvcMethodContext) {

		if (TypeChecker.isNull(mvcMethodContext)) {
			return false;
		}

		Object mvcMethodContextResult = mvcMethodContextFormatTextResolver
				.resolve(ActionContextUtils.getViewerType(), mvcMethodContext,
						getBrowserCharset());

		if (TypeChecker.isNull(mvcMethodContextResult)) {
			return false;
		}

		if (mvcMethodContextResult instanceof byte[]) {

			ResponseUtils.write(viewerType.getContentType(), System
					.currentTimeMillis()
					+ "." + viewerType.getExtension(),
					(byte[]) mvcMethodContextResult, getBrowserCharset(),
					request, response);

			return true;
		}

		ResponseUtils.write(
				ActionContextUtils.getViewerType().getContentType(),
				getBrowserCharset(), (String) mvcMethodContextResult,
				this.response);

		return true;
	}

	protected Object invokeMethod(Method method) {

		Class[] parameterTypes = null;

		Object[] parameterValues = null;

		try {

			parameterTypes = method.getParameterTypes();

			if (TypeChecker.isEmpty(parameterTypes)) {

				return method.invoke(this, null);

			}

			parameterValues = getParameterValues(method, parameterTypes);

			return method.invoke(this, parameterValues);

		} catch (Exception e) {

			this.printInvokeMethodErrorLog(parameterTypes, parameterValues);

			throw ExceptionUtils.convertThrowableToBaseException(e);
		}

	}

	private void printInvokeMethodErrorLog(Class[] parameterTypes,
			Object[] parameterValues) {

		if (TypeChecker.isEmpty(parameterTypes)) {
			return;
		}

		logger.info("Invoke Method Parameter Error Log Start.................");

		if (TypeChecker.isEmpty(parameterValues)) {
			logger.info("Cannot found any parameter values!!!");
			return;
		}

		for (int i = 0; i < parameterTypes.length; i++) {

			logger.info("Parameter Class [" + i + "] :"
					+ parameterTypes[i].getName());

			if (i < parameterValues.length) {
				logger.info("Parameter Value [" + i + "] :"
						+ ObjectAnalyzer.toString(parameterValues[i]));

			} else {
				logger.info("Parameter Value [" + i + "] : Lost");
			}

		}

		logger.info("Invoke Method Parameter Error Log End.................");

	}

	private Object wrapStringToTargetValue(MethodParameter annoParam, Class clz) {

		if (clz == String[].class) {

			return ActionContextUtils.getHttpRequest().getParameterValues(
					annoParam.value());
		}

		String value = ActionContextUtils.getHttpParameter(annoParam.value());

		if (!"NULL".equalsIgnoreCase(annoParam.defValue())) {
			value = StringUtils.trimToEmpty(value, annoParam.defValue());

		}

		if (clz == String.class) {
			return value;
		}

		if (clz == int.class) {
			return NumberUtils.parseInt(value);
		}

		if (TypeChecker.isEmpty(value)) {
			return null;
		}

		if (clz == Integer.class) {

			return NumberUtils.parseInt(value);
		}

		if (clz == Double.class) {

			return NumberUtils.parseDouble(value);
		}

		if (clz == Long.class) {

			return NumberUtils.parseLong(value);
		}

		if (clz == Float.class) {

			return (float) NumberUtils.parseDouble(value);
		}

		throw new IllegalArgumentException("Not Support Type:" + clz.getName());

	}

	private Object[] getParameterValues(Method method, Class[] parameterTypes)
			throws Exception {

		List<Object> values = new ArrayList<Object>(parameterTypes.length);

		MethodHttpParametersClassIterator httpParamIt = getMethodHttpParametersClassIterator(method);

		Annotation[] parameterAnnotations = ClassUtils
				.getMethodParameterAnnotationsByAnnotation(method,
						MethodParameter.class);

		Annotation[] userRequestAnno = ClassUtils
				.getMethodParameterAnnotationsByAnnotation(method,
						MethodUserRequest.class);

		int index = -1;

		ActionContext<Object> actionContext = new ActionContext<Object>(
				com.opensymphony.xwork2.ActionContext.getContext());

		for (Class clz : parameterTypes) {

			index++;

			if (clz == XPathParser.class) {

				XPathParser xPathParser = XPathParser.getXPathParserWithLogger(
						ActionContextUtils.getHttpRequest().getInputStream(),
						this.getBrowserCharset());

				values.add(xPathParser);

				continue;
			}

			if (!TypeChecker.isNull(parameterAnnotations[index])) {

				MethodParameter annoParam = (MethodParameter) parameterAnnotations[index];

				Object paramValue = this
						.wrapStringToTargetValue(annoParam, clz);

				com.opensymphony.xwork2.ActionContext.getContext().put(
						annoParam.value(), paramValue);

				LOG.info("MethodParameter  Name:" + annoParam.value()
						+ " Value:" + paramValue + " In Action Context Put");

				values.add(paramValue);

				continue;
			}

			if (!TypeChecker.isNull(userRequestAnno[index])) {

				LOG.info("MethodUserRequest  Find! index:" + index);

				if (!TypeChecker.isNull(ActionContextUtils.getActionModel())
						&& !WebUser.class.isAssignableFrom(ActionContextUtils
								.getActionModel().getClass())) {
					throw new IllegalArgumentException(
							"Please provide a user request parameter!");
				}

				values.add(ActionContextUtils.getActionModel());

				continue;
			}

			if (clz == com.opensymphony.xwork2.ActionContext.class) {
				throw new IllegalArgumentException("Please use "
						+ ActionContext.class.getName()
						+ " to replace xwork ActionContext!");
			}

			if (WebUser.class.isAssignableFrom(clz)) {

				// 登陆的User
				if (!ActionContextUtils.isBeforeLoginStage()) {

					values.add(MvcSecurityActionContextUtils.getWebUser());

					continue;

				}

				if (!TypeChecker.isNull(ActionContextUtils.getActionModel())
						&& WebUser.class.isAssignableFrom(ActionContextUtils
								.getActionModel().getClass())) {

					values.add(ActionContextUtils.getActionModel());

					continue;
				}

				throw new IllegalArgumentException(
						"The method parameter[WebUser] cannot be injected if the method is used before login!");

			}

			if (ActionContextUtils.isActionModelClass(clz)) {

				values.add(ActionContextUtils.getActionModel());

				continue;
			}

			if (clz.isAnnotationPresent(InitPageParameter.class)) {

				Object value = this.assembleBeanFields(ConstructorUtils
						.newInstance(clz));

				values.add(value);

				actionContext.setObjectToContextMap(clz, value);

				continue;
			}

			if (clz == ActionContext.class) {
				values.add(actionContext);
				continue;
			}

			if (clz == HttpServletRequest.class) {
				values.add(this.getHttpServletRequest());
				continue;
			}

			if (clz == HttpServletResponse.class) {
				values.add(this.getHttpServletResponse());
				continue;
			}

			if (clz == String.class && httpParamIt.hasNext()) {

				values.add(httpParamIt.next());

				continue;
			}

			if (MvcMethodContext.class.isAssignableFrom(clz)) {

				values.add(ActionContextUtils.getMvcMethodContext());

				continue;
			}

			this.setParameterValueForMethod(values, method, clz);

		}

		return values.toArray(new Object[values.size()]);
	}

	protected abstract void setParameterValueForMethod(List values,
			Method method, Class parameterClass);

	private MethodHttpParametersClassIterator getMethodHttpParametersClassIterator(
			Method method) {

		MethodHttpParametersClass httpAnnotation = method
				.getAnnotation(MethodHttpParametersClass.class);

		if (TypeChecker.isNull(httpAnnotation)) {
			return Method_HttpParameters_ClassIt;
		}

		return new MethodHttpParametersClassIterator(this
				.getHttpServletRequest(), httpAnnotation);
	}

	public Object getModel() {

		String actionModelClassName = PropertiesUtils
				.getProperties(
						ClassUtils
								.getClassToPath(
										this.getClass(),
										SupportActionConstants.ModelDriven_Properties_Resource_Name),
						true, true)
				.getProperty(
						SupportActionConstants.ModelDriven_Property_Key_ClassName_Mapper_Method
								+ ActionContextUtils.getActionMethodName());

		Class actionModelClass = ActionContextUtils
				.getModelDrivenClassByAnnotation();

		if (!TypeChecker.isNull(actionModelClass)) {
			actionModelClassName = actionModelClass.getName();
		}

		if (TypeChecker.isEmpty(actionModelClassName)) {

			logger
					.warn("Warning, Please confirm whether you should provide a action model class [@ModelDriven] with method ["
							+ ActionContextUtils.getActionMethodName()
							+ "/"
							+ this.getClass().getSimpleName() + "] !");

			ActionContextUtils.setActionModel(this);

			return ActionContextUtils.getActionModel();
		}

		ActionContextUtils.setActionModel(ConstructorUtils
				.newInstance(actionModelClassName));

		logger.info("\n\n------- Action Model :"
				+ ActionContextUtils.getActionModel().getClass()
						.getSimpleName() + "------\n\n");

		assembleBeanFields(ActionContextUtils.getActionModel());

		this.assembleRequestBeans(ActionContextUtils.getActionModel());

		if (ActionContextUtils.getActionModel() instanceof InitializingModelDrivenBean) {
			((InitializingModelDrivenBean) ActionContextUtils.getActionModel())
					.afterProperties();
		}

		return ActionContextUtils.getActionModel();
	}

	protected void assembleRequestBeans(Object bean) {

		if (TypeChecker.isNull(this.requestBeansAssembleFactory)) {
			return;
		}

		requestBeansAssembleFactory.resolveBeans(bean, this
				.getHttpServletRequest());

	}

	protected Object assembleBeanFields(Object bean) {

		SpringApplicationContextHolder.inject(bean);

		for (BeanAssembleFactory beanAssembleFactory : beanAssembleFactories) {
			beanAssembleFactory.assemble(bean);
		}

		return bean;

	}

	protected void doInitMethodGlabolParameters() {

		if (!ActionContextUtils.getApplication().containsKey("_struts.devMode")) {

			ActionContextUtils.getApplication().put("_struts.devMode",
					this.isStrutsDevModeOpen());

			ActionContextUtils.setFileVersion(System.currentTimeMillis());

			ActionContextUtils.getApplication().put("_version",
					ActionContextUtils.getFileVersion());

			return;
		}

		if (this.isStrutsDevModeOpen()) {

			ActionContextUtils.setFileVersion(System.currentTimeMillis());

			ActionContextUtils.getApplication().put("_version",
					ActionContextUtils.getFileVersion());
		}

	}

	public String getInputResultName() {

		return pageIndicator;
	}

	public void publishEvent(ApplicationEvent event) {

		this.getApplicationContext().publishEvent(event);

	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// 页面跳转的名称
	protected String pageIndicator;

	@Autowired(required = false)
	private List<BeanAssembleFactory> beanAssembleFactories = new ArrayList<BeanAssembleFactory>();

	private static final MethodHttpParametersClassIterator Method_HttpParameters_ClassIt = new MethodHttpParametersClassIterator();

	@Autowired(required = false)
	private I18NMessageFormat i18nMessageFormat = I18NMessageFormat.I18nMessage_No_Format_As_Default;

	@Autowired(required = false)
	private AbstractUIHtmlFieldStyleSettingsController uiHtmlFieldStyleSettingsController = AbstractUIHtmlFieldStyleSettingsController.Default_Instance;

	@Autowired(required = false)
	private RequestBeansAssembleFactory requestBeansAssembleFactory = null;

	@Autowired
	private MvcMethodContextFormatTextResolver mvcMethodContextFormatTextResolver;

	private boolean hasMvcMethodContextError;

	protected Log logger = LogFactory.getLog(this.getClass());

}
