package com.rapid.j2ee.framework.mvc.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.springframework.context.ApplicationContext;

import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.rapid.j2ee.framework.core.charset.CharsetType;
import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.SupportActionConstants;

public abstract class MvcBaseActionSupportContainer extends ActionSupport
		implements ServletRequestAware, ServletResponseAware {

	protected transient HttpServletRequest request;

	protected transient HttpServletResponse response;

	protected Container container = null;

	public MvcBaseActionSupportContainer() {

	}

	public String getRequestURI() {
		return this.request.getRequestURI();
	}

	public HttpServletRequest getHttpServletRequest() {
		return this.request;
	}

	public void setServletRequest(HttpServletRequest request) {

		this.request = request;

	}

	public void setServletResponse(HttpServletResponse response) {

		this.response = response;

	}

	public HttpServletResponse getHttpServletResponse() {
		return this.response;
	}

	@Inject
	public void setContainer(Container container) {
		this.container = container;
	}

	public boolean isStrutsDevModeOpen() {
		return getStrutsConstantByBoolean("struts.devMode", false);
	}

	protected final boolean getStrutsConstantByBoolean(String key,
			boolean defValue) {
		return TypeChecker.isSpecialTrue(getStrutsConstantByValue(key, String
				.valueOf(defValue)));
	}

	protected final String getStrutsConstantByValue(String key, String defValue) {

		String configureValue = this.container.getInstance(String.class, key);

		if (TypeChecker.isEmpty(configureValue)) {
			return defValue;
		}

		return configureValue;
	}

	public String getBrowserCharset() {
		return this.getStrutsConstantByValue(
				SupportActionConstants.SupportAction_Struts_Page_Encoding_Key,
				Charsets.getCharsetInstance(CharsetType.UTF_8).getCharset());
	}

	public ApplicationContext getApplicationContext() {

		return SpringApplicationContextHolder.getApplicationContext();
	}

}
