package com.rapid.j2ee.framework.mvc.web.annotation;

import java.util.Arrays;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;

import com.rapid.j2ee.framework.core.utils.ObjectUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;

public class MethodHttpParametersClassIterator implements Iterator<String> {

	private Iterator<String> requestNames;

	private HttpServletRequest request;

	@SuppressWarnings("unchecked")
	public MethodHttpParametersClassIterator() {
		requestNames = ObjectUtils.EMPTY_LIST.iterator();
	}

	public MethodHttpParametersClassIterator(HttpServletRequest request,
			MethodHttpParametersClass parameter) {
		requestNames = (Iterator<String>) Arrays.asList(
				StringUtils.splitBySeparator(parameter.value(), ","))
				.iterator();

		this.request = request;
	}

	public boolean hasNext() {

		return requestNames.hasNext();
	}

	public String next() {

		return ActionContextUtils.getHttpParameter(requestNames.next(), "");
	}

	public String[] nexts() {

		String key = requestNames.next();

		if (ActionContextUtils.getParameters().get(key) instanceof String[]) {
			return (String[]) ActionContextUtils.getParameters().get(key);
		}

		return this.request.getParameterValues(key);
	}

	public void remove() {
		throw new UnsupportedOperationException(" remove() method.");

	}

}
