package com.rapid.j2ee.framework.mvc.web.context;

import com.rapid.j2ee.framework.core.io.xml.XmlFieldAttribute;
import com.rapid.j2ee.framework.mvc.constants.OperationResult;
import com.rapid.j2ee.framework.mvc.constants.OperationResultConstants;
import com.rapid.j2ee.framework.mvc.web.annotation.StreamFieldAttribute;

public abstract class AbstractMvcMethodBodyContext<T> extends
		GeneralMvcMethodContext implements MvcMethodEmptyContext {

	@XmlFieldAttribute
	@StreamFieldAttribute
	private T body;

	private static Object Default_Object_Value = new Object();

	private static Object Default_Success_Object_Value = new Object();

	public AbstractMvcMethodBodyContext() {

	}

	public GeneralMvcMethodContext prepare(OperationResult operationResult, T body) {
		this.messageCode = operationResult.getMessageCode();
		this.resultCode = operationResult.getResultCode();
		this.messageDefault = operationResult.getMessageDefault();
		this.body = body;

		return this;

	}

	public GeneralMvcMethodContext prepare(OperationResult operationResult) {
		
		this.messageCode = operationResult.getMessageCode();
		this.resultCode = operationResult.getResultCode();
		this.messageDefault = operationResult.getMessageDefault();
		body = (T) Default_Success_Object_Value;

		return this;
	}

	public void prepare(T body) {
		this.prepare(OperationResultConstants.SUCCESS_OPERATION, body);

	}

	public T getBody() {
		return body;
	}

	public boolean isEmpty() {

		if (this.body == Default_Object_Value) {
			return false;
		}

		return this.isEmptyBody(this.body);
	}

	protected abstract boolean isEmptyBody(T body);

}
