package com.rapid.j2ee.framework.mvc.web.context;

import com.rapid.j2ee.framework.core.exception.ApplicationException;
import com.rapid.j2ee.framework.core.exception.BaseException;
import com.rapid.j2ee.framework.core.io.xml.XmlFieldAttribute;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.OperationResult;
import com.rapid.j2ee.framework.mvc.constants.OperationResultConstants;
import com.rapid.j2ee.framework.mvc.constants.SupportActionConstants;
import com.rapid.j2ee.framework.mvc.web.context.resolve.MvcMethodContextOutputFormatResolver;

public class GeneralMvcMethodContext implements
		MvcMethodContextI18NMessageAccessable, MvcMethodContext {

	protected String messageCode;

	protected String messageDefault;

	protected int resultCode;

	protected String i18nMessage;

	protected Object[] resultMessageArguments;

	protected MvcMethodContextOutputFormatResolver mvcMethodContextOutputFormatResolver;

	@XmlFieldAttribute
	protected Object outputResult;

	public GeneralMvcMethodContext() {
		this.messageCode = OperationResultConstants.SUCCESS_OPERATION
				.getMessageCode();
		this.resultCode = OperationResultConstants.SUCCESS_OPERATION
				.getResultCode();
		this.messageDefault = OperationResultConstants.SUCCESS_OPERATION
				.getMessageDefault();
	}

	public GeneralMvcMethodContext(ApplicationException applicationException) {
		this.resultCode = applicationException.getResultCode();
		this.messageCode = applicationException.getResultMessageCode();
		this.messageDefault = applicationException.getResultMessage();
		this.resultMessageArguments = applicationException
				.getResultMessageArguments();
		this.outputResult = applicationException.getOutputResult();

	}

	public GeneralMvcMethodContext(BaseException baseException) {
		this.resultCode = baseException.getResultCode();
		this.messageCode = SupportActionConstants.SupportAction_SystemException_MessageCode;
		this.messageDefault = baseException.getResultMessage();

	}

	public GeneralMvcMethodContext prepare(OperationResult operationResult) {
		this.messageCode = operationResult.getMessageCode();
		this.resultCode = operationResult.getResultCode();
		this.messageDefault = operationResult.getMessageDefault();
		return this;

	}

	public String getMessage() {
		return StringUtils.trimToEmpty(i18nMessage, this.messageDefault);
	}

	public void setI18nMessage(String message) {

		if (!TypeChecker.isEmpty(i18nMessage)) {
			return;
		}
		i18nMessage = message;
	}

	public String getMessageCode() {
		return messageCode;
	}

	public String getMessageDefault() {
		return messageDefault;
	}

	public int getResultCode() {
		return resultCode;
	}

	public boolean isResultSuccess() {

		return resultCode == OperationResult.Success;
	}

	public Object[] getResultMessageArguments() {
		return resultMessageArguments;
	}

	public GeneralMvcMethodContext setResultMessageArguments(
			Object... resultMessageArguments) {
		this.resultMessageArguments = resultMessageArguments;
		return this;
	}

	public Object getOutputResult() {
		return outputResult;
	}

	public MvcMethodContextOutputFormatResolver getMvcMethodContextOutputFormatResolver() {
		return mvcMethodContextOutputFormatResolver;
	}

	public void setMvcMethodContextOutputFormatResolver(
			MvcMethodContextOutputFormatResolver mvcMethodContextOutputFormatResolver) {
		this.mvcMethodContextOutputFormatResolver = mvcMethodContextOutputFormatResolver;
	}

}
