package com.rapid.j2ee.framework.mvc.web.context;

import com.rapid.j2ee.framework.core.io.xml.XmlFieldAttribute;
import com.rapid.j2ee.framework.mvc.constants.OperationResult;
import com.rapid.j2ee.framework.mvc.constants.OperationResultConstants;
import com.rapid.j2ee.framework.mvc.web.annotation.StreamFieldAttribute;

public class MvcMethodPrimaryKeyContext extends GeneralMvcMethodContext {

	@XmlFieldAttribute
	@StreamFieldAttribute
	private MvcMethodContextPrimaryKeyBean mvcMethodContextPrimaryKeyBean;

	public MvcMethodPrimaryKeyContext() {

	}

	public MvcMethodPrimaryKeyContext prepare(OperationResult operationResult, String... primaryKeys) {
		
		this.messageCode = operationResult.getMessageCode();
		this.resultCode = operationResult.getResultCode();
		this.messageDefault = operationResult.getMessageDefault();

		mvcMethodContextPrimaryKeyBean = new MvcMethodContextPrimaryKeyBean(
				primaryKeys);
		
		return this;

	}

	public void prepare(String... primaryKeys) {
		this.prepare(OperationResultConstants.SUCCESS_OPERATION, primaryKeys);

	}

	public MvcMethodContextPrimaryKeyBean getMvcMethodContextPrimaryKeyBean() {
		return mvcMethodContextPrimaryKeyBean;
	}

}
