package com.rapid.j2ee.framework.mvc.web.context.resolve;

import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContext;

public class MvcMethodContextOutputFormatRemoveTagNameResolver extends
		MvcMethodContextOutputFormatResolverAdapter {

	private String[] tagNames;

	public MvcMethodContextOutputFormatRemoveTagNameResolver() {

	}

	public MvcMethodContextOutputFormatRemoveTagNameResolver(String... tagNames) {
		this.tagNames = tagNames;
	}

	@Override
	protected Object doResolveXml(Object content,
			MvcMethodContext mvcMethodContext) {

		if (TypeChecker.isEmpty(tagNames)) {
			return content;
		}

		String contentText = String.valueOf(content);

		for (String tagName : tagNames) {

			contentText = StringUtils.replaceAll(contentText, "<" + tagName
					+ ">", "");
			contentText = StringUtils.replaceAll(contentText, "<" + tagName
					+ "/>", "");
			contentText = StringUtils.replaceAll(contentText, "</" + tagName
					+ ">", "");
		}

		return contentText;
	}

	public void setTagNames(String[] tagNames) {
		this.tagNames = tagNames;
	}

}
