package com.rapid.j2ee.framework.mvc.web.error;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.rapid.j2ee.framework.core.exception.ApplicationException;
import com.rapid.j2ee.framework.core.exception.BaseException;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.exception.SystemException;
import com.rapid.j2ee.framework.core.io.json.JsonUtils;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.SupportActionConstants;
import com.rapid.j2ee.framework.mvc.constants.ViewerType;
import com.rapid.j2ee.framework.mvc.exception.MvcMethodContextException;
import com.rapid.j2ee.framework.mvc.exception.UploadFileExcceedLimitationApplicationException;
import com.rapid.j2ee.framework.mvc.i18n.I18NMessageFormat;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;
import com.rapid.j2ee.framework.mvc.web.MvcWebActionSupport;
import com.rapid.j2ee.framework.mvc.web.context.GeneralMvcMethodContext;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContext;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContextI18NMessageAccessable;
import com.rapid.j2ee.framework.mvc.web.i18n.I18NMessageMvcMethodContext;
import com.rapid.j2ee.framework.mvc.web.logger.SystemExceptionOccurLogger;

public abstract class AbstractSupportActionExceptionHandler implements
		SupportActionExceptionHandler {

	private Log log = LogFactory.getLog(this.getClass());

	public String handleException(Throwable e) {

		try {
			String dispatcherPage = doHandleException(e);

			log.info("Exception Handle Dispatcher Page:" + dispatcherPage);

			return dispatcherPage;

		} catch (Exception exp) {

		}

		log
				.info("Exception Handle Dispatcher Page:"
						+ SupportActionConstants.SupportAction_Page_Indicator_By_Global_Page);

		return SupportActionConstants.SupportAction_Page_Indicator_By_Global_Page;
	}

	public String doHandleException(Throwable e) {

		BaseException exp = ExceptionUtils.convertThrowableToBaseException(e);

		this.print(exp);

		MvcMethodContext mvcMethodContext = this
				.getMvcMethodContextByExceptionType(exp);

		I18NMessageMvcMethodContext.toI18NMessage(i18nMessageFormat,
				mvcMethodContext, exp);

		return this.registryForDispatcher(mvcMethodContext, exp);

	}

	protected String registryForDispatcher(MvcMethodContext mvcMethodContext,
			BaseException exp) {

		this.setMvcMethodContextRequestMessage(exp, mvcMethodContext);

		if (ActionContextUtils.isMethodDownloadResourceMode()) {

			HttpServletResponse response = ActionContextUtils.getHttpResponse();
			response.reset();
			response.setStatus(404);
			response.setHeader("status", "404");
			response.setHeader("result-code", "404");

			return null;
		}

		if (ActionContextUtils.getViewerType() == ViewerType.Json
				&& ActionContextUtils.getMvcBaseActionSupport() instanceof MvcWebActionSupport) {

			if (exp instanceof UploadFileExcceedLimitationApplicationException) {

				ActionContextUtils
						.getHttpRequest()
						.setAttribute(
								SupportActionConstants.SupportAction_Result_Json_Request_Key,
								JsonUtils.formatJsonText(mvcMethodContext));

				return SupportActionConstants.SupportAction_Page_Json_Indicator_ByUploadExcceedLimitSize_ApplicationException;
			}
		}

		if (ActionContextUtils.getViewerType().isWriteResponse()) {

			ActionContextUtils.getMvcBaseActionSupport()
					.doWriteMvcMethodContextToResponse(mvcMethodContext);

			return null;
		}

		String forwardPage = this.getExceptionDispatcher(exp);

		if (!TypeChecker.isNull(ActionContextUtils.getMvcMethodContext())
				&& ActionContextUtils.getMvcMethodConfigurer().type() == ViewerType.Html) {

			return forwardPage + "_Html";
		}

		return forwardPage;

	}

	private void setMvcMethodContextRequestMessage(BaseException exp,
			MvcMethodContext mvcMethodContext) {

		log.info("MvcMethodContextRequestMessage Context:"
				+ ObjectAnalyzer.toString(mvcMethodContext) + " Message : "
				+ mvcMethodContext.getMessage());

		ActionContextUtils.getHttpRequest().setAttribute(
				MvcMethodContext.class.getSimpleName(), mvcMethodContext);

		String messageCode = mvcMethodContext.getMessageCode();

		if (exp instanceof SystemException) {
			messageCode = "GlobalError";
		}

		ActionContextUtils.getHttpRequest().setAttribute(
				ErrorConstants.Global_Message_Request_ResultCode_KeyName,
				mvcMethodContext.getResultCode());

		ActionContextUtils.getHttpRequest().setAttribute(
				ErrorConstants.Global_Message_Request_ResultMessage_KeyName,
				mvcMethodContext.getMessage());

		ActionContextUtils
				.getHttpRequest()
				.setAttribute(
						ErrorConstants.Global_Message_Request_ResultMessageCode_KeyName,
						messageCode);

		ActionContextUtils
				.getHttpRequest()
				.setAttribute(
						ErrorConstants.Global_Message_Request_ResultOrignalMessageCode_KeyName,
						mvcMethodContext.getMessageCode());
	}

	private void print(BaseException exp) {

		if (exp instanceof ApplicationException) {

			log.info("Warning! The Application Exception [" + exp.getMessage()
					+ "]");

			return;

		}

		if (!TypeChecker.isNull(systemExceptionOccurLogger)) {
			systemExceptionOccurLogger.log(exp);
		}

		log.error("Error! System Exception....", exp);

		exp.printStackTrace();

		// Could not open JDBC Connection for transaction

	}

	protected String getExceptionDispatcher(BaseException exp) {

		if (exp instanceof ApplicationException) {

			return ((ApplicationException) exp).getPageIndicator();
		}

		return SupportActionConstants.SupportAction_Page_Indicator_By_SystemException;
	}

	private MvcMethodContext getMvcMethodContextByExceptionType(
			BaseException exp) {

		if (exp instanceof MvcMethodContextException) {
			return ((MvcMethodContextException) exp).getMvcMethodContext();
		}

		if (exp instanceof ApplicationException) {

			return new GeneralMvcMethodContext((ApplicationException) exp);
		}

		return new GeneralMvcMethodContext(exp);
	}

	@Autowired(required = false)
	private I18NMessageFormat i18nMessageFormat = I18NMessageFormat.I18nMessage_No_Format_As_Default;

	@Autowired(required = false)
	private SystemExceptionOccurLogger systemExceptionOccurLogger;

}
