package com.rapid.j2ee.framework.mvc.web.i18n;

import com.itextpdf.text.log.SysoLogger;
import com.rapid.j2ee.framework.core.exception.BaseException;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.exception.SystemException;
import com.rapid.j2ee.framework.core.utils.ObjectAnalyzer;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.OperationResultConstants;
import com.rapid.j2ee.framework.mvc.i18n.I18NMessageFormat;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContext;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContextI18NMessageAccessable;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodEmptyContext;

public class I18NMessageMvcMethodContext {

	private I18NMessageMvcMethodContext() {

	}

	public static void toI18NMessage(I18NMessageFormat i18nMessageFormat,
			MvcMethodContext mvcMethodContext) {
		toI18NMessage(i18nMessageFormat, mvcMethodContext, null);
	}

	public static void toI18NMessage(I18NMessageFormat i18nMessageFormat,
			MvcMethodContext mvcMethodContext, BaseException exp) {

		if (mvcMethodContext instanceof MvcMethodEmptyContext) {

			if (((MvcMethodEmptyContext) mvcMethodContext).isEmpty()) {
				((MvcMethodEmptyContext) mvcMethodContext)
						.prepare(OperationResultConstants.FAILED_SUBMIT_SEARCH_NO_RECORDS);
			}

		}

		if (!(mvcMethodContext instanceof MvcMethodContextI18NMessageAccessable)) {
			return;
		}

		if (exp instanceof SystemException) {

			if (TypeChecker.isTrue(String.valueOf(ActionContextUtils
					.getApplication().get("_struts.devMode")))) {

				if (mvcMethodContext instanceof MvcMethodContextI18NMessageAccessable) {

					((MvcMethodContextI18NMessageAccessable) mvcMethodContext)
							.setI18nMessage(StringUtils
									.getStringContextWithinLength(
											ExceptionUtils
													.printThrowableStack(exp),
											2, 1000, "..."));

					return;
				}

			}
		}

		String[] messageCodes = {
				ActionContextUtils.getActionClass().getSimpleName() + "."
						+ ActionContextUtils.getActionMethodName() + "."
						+ mvcMethodContext.getMessageCode(),
				mvcMethodContext.getMessageCode() };

		((MvcMethodContextI18NMessageAccessable) mvcMethodContext)
				.setI18nMessage(i18nMessageFormat.format(messageCodes,
						mvcMethodContext.getMessageDefault(), mvcMethodContext
								.getResultMessageArguments()));

	}

}
