package com.rapid.j2ee.framework.mvc.web.interceptor;

import org.springframework.beans.factory.InitializingBean;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.rapid.j2ee.framework.core.spring.SpringApplicationContextHolder;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.security.MvcSecurityAuthorityFilter;
import com.rapid.j2ee.framework.mvc.security.logger.AuditActionLoggerConfigurer;
import com.rapid.j2ee.framework.mvc.security.logic.MvcSecurityCleanUpInterceptorHandler;
import com.rapid.j2ee.framework.mvc.web.error.SupportActionExceptionHandler;

public class MvcWebActionControllerInterceptor extends AbstractInterceptor
		implements InitializingBean {

	private static final long serialVersionUID = 1L;

	@Override
	public String intercept(ActionInvocation actionInvocation) {

		return new MvcWebActionController(actionInvocation,
				mvcSecurityAuthorityFilter, supportActionExceptionHandler,
				auditActionLoggerConfigurer,
				mvcSecurityCleanUpInterceptorHandler).invoke();

	}

	public void setSupportActionExceptionHandler(
			SupportActionExceptionHandler supportActionExceptionHandler) {
		this.supportActionExceptionHandler = supportActionExceptionHandler;
	}

	public void setMvcSecurityAuthorityFilter(
			MvcSecurityAuthorityFilter mvcSecurityAuthorityFilter) {
		this.mvcSecurityAuthorityFilter = mvcSecurityAuthorityFilter;
	}

	public void setAuditActionLoggerConfigurer(
			AuditActionLoggerConfigurer auditActionLoggerConfigurer) {
		this.auditActionLoggerConfigurer = auditActionLoggerConfigurer;
	}

	public void setMvcSecurityCleanUpInterceptorHandler(
			MvcSecurityCleanUpInterceptorHandler mvcSecurityCleanUpInterceptorHandler) {
		this.mvcSecurityCleanUpInterceptorHandler = mvcSecurityCleanUpInterceptorHandler;
	}

	private MvcSecurityCleanUpInterceptorHandler mvcSecurityCleanUpInterceptorHandler = MvcSecurityCleanUpInterceptorHandler.Default_Do_Nothing;

	
	
	private SupportActionExceptionHandler supportActionExceptionHandler = SupportActionExceptionHandler.No_AnyProcess_When_Error_As_Default;

	private MvcSecurityAuthorityFilter mvcSecurityAuthorityFilter;

	private AuditActionLoggerConfigurer auditActionLoggerConfigurer;


	public void afterPropertiesSet() throws Exception {

		if (!TypeChecker.isNull(auditActionLoggerConfigurer)) {
			return;
		}

		for (String beanName : SpringApplicationContextHolder
				.getApplicationContext().getBeanNamesForType(
						AuditActionLoggerConfigurer.class)) {

			AuditActionLoggerConfigurer auditActionLoggerConfigurer = SpringApplicationContextHolder
					.getApplicationContext().getBean(beanName,
							AuditActionLoggerConfigurer.class);

			if ("MvcWeb".equalsIgnoreCase(auditActionLoggerConfigurer
					.getAuditActionLoggerQualifier())) {
				this.auditActionLoggerConfigurer = auditActionLoggerConfigurer;
			}

		}

	}

}
