package com.rapid.j2ee.framework.mvc.web.logger;

import java.beans.BeanInfo;
import java.io.File;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.charset.Charsets;
import com.rapid.j2ee.framework.core.exception.ExceptionUtils;
import com.rapid.j2ee.framework.core.io.file.FileWriter;
import com.rapid.j2ee.framework.core.utils.StringUtils;

public class SystemExceptionOccurLogger implements InitializingBean {

	public void log(Exception exp) {

		try {
			String error = ExceptionUtils.printThrowableStack(exp);
			if (!isExceptionMatched(error)) {
				return;
			}
			fileWriter.writeln(error);
			fileWriter.flush();
		} catch (Throwable e) {
			e.printStackTrace();
		}
	}

	private boolean isExceptionMatched(String error) {

		for (String keyword : this.errorKeywords) {
			if (error.toLowerCase().indexOf(keyword.toLowerCase()) >= 0) {
				return true;
			}
		}

		return false;
	}

	public void afterPropertiesSet() throws Exception {

		Assert.hasLength(this.loggerLocation);

		Assert.noNullElements(this.errorKeywords);

		fileWriter = new FileWriter(new File(this.loggerLocation),
				Charsets.UTF_8);

	}

	public void setErrorKeywords(String[] errorKeywords) {
		this.errorKeywords = errorKeywords;
	}

	public void setLoggerLocation(String loggerLocation) {
		this.loggerLocation = loggerLocation;
	}

	@Override
	protected void finalize() throws Throwable {
		fileWriter.flush();
		fileWriter.close();
	}

	private String[] errorKeywords;

	private String loggerLocation;

	private FileWriter fileWriter = null;

}
