package com.rapid.j2ee.framework.mvc.web.text;

import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.mvc.constants.ViewerType;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContext;
import com.rapid.j2ee.framework.mvc.web.error.ErrorConstants;

@Component
public class MvcMethodContextFormatHtmlText implements
		MvcMethodContextFormatText {

	public Object resolve(MvcMethodContext mvcMethodContext, String charset) {

		ActionContextUtils.getHttpRequest().setAttribute(
				ErrorConstants.Global_Message_Request_ResultCode_KeyName,
				mvcMethodContext.getResultCode());

		ActionContextUtils.getHttpRequest().setAttribute(
				ErrorConstants.Global_Message_Request_ResultMessage_KeyName,
				mvcMethodContext.getMessage());

		ActionContextUtils
				.getHttpRequest()
				.setAttribute(
						ErrorConstants.Global_Message_Request_ResultMessageCode_KeyName,
						mvcMethodContext.getMessageCode());

		ActionContextUtils
				.getHttpRequest()
				.setAttribute(
						ErrorConstants.Global_Message_Request_ResultOrignalMessageCode_KeyName,
						mvcMethodContext.getMessageCode());

		return null;
	}

	public ViewerType resolveType() {

		return ViewerType.Html;
	}

}
