package com.rapid.j2ee.framework.mvc.web.text;

import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.core.io.json.JsonUtils;
import com.rapid.j2ee.framework.mvc.constants.ViewerType;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContext;

@Component
public class MvcMethodContextFormatJsonText extends
		AbstractMvcMethodContextFormatText<String> {

	@Override
	public String doResolveMethodContext(MvcMethodContext mvcMethodContext, String charset) {

		return JsonUtils.formatJsonText(mvcMethodContext);
	}

	public ViewerType resolveType() {

		return ViewerType.Json;
	}

}
