package com.rapid.j2ee.framework.mvc.web.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.ViewerType;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContext;

@Component
public class MvcMethodContextFormatTextResolver implements InitializingBean {

	public Object resolve(ViewerType viewerType,
			MvcMethodContext mvcMethodContext, String charset) {

		if (TypeChecker.isNull(viewerType)) {
			return null;
		}

		Assert.notNull(mvcMethodContext);

		Assert
				.isTrue(
						mvcMethodContextFormatTextMapper
								.containsKey(viewerType),
						"Please provide a MvcMethodContextFormatText implemented class to handle type ["
								+ viewerType + "]!");

		return mvcMethodContextFormatTextMapper.get(viewerType).resolve(
				mvcMethodContext, charset);
	}

	public void afterPropertiesSet() throws Exception {

		for (MvcMethodContextFormatText mvcMethodContextFormatText : mvcMethodContextFormatTexts) {
			mvcMethodContextFormatTextMapper.put(mvcMethodContextFormatText
					.resolveType(), mvcMethodContextFormatText);
		}
	}

	public MvcMethodContextFormatTextResolver() {

	}

	private Map<ViewerType, MvcMethodContextFormatText> mvcMethodContextFormatTextMapper = new HashMap<ViewerType, MvcMethodContextFormatText>();

	@Autowired(required = false)
	private List<MvcMethodContextFormatText> mvcMethodContextFormatTexts = new ArrayList<MvcMethodContextFormatText>();

}
