package com.rapid.j2ee.framework.mvc.webservice.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.ViewerType;
import com.rapid.j2ee.framework.mvc.exception.ActionMvcMethodConfigurerLostApplicationException;
import com.rapid.j2ee.framework.mvc.security.MvcSecurityAuthorityFilter;
import com.rapid.j2ee.framework.mvc.security.logger.AuditActionLoggerConfigurer;
import com.rapid.j2ee.framework.mvc.security.logic.MvcSecurityCleanUpInterceptorHandler;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;
import com.rapid.j2ee.framework.mvc.web.error.SupportActionExceptionHandler;
import com.rapid.j2ee.framework.mvc.web.interceptor.MvcWebActionController;

public class MvcWebServiceController extends MvcWebActionController {

	public MvcWebServiceController(
			ActionInvocation actionInvocation,
			MvcSecurityAuthorityFilter mvcSecurityAuthorityFilter,
			SupportActionExceptionHandler supportActionExceptionHandler,
			AuditActionLoggerConfigurer auditActionLoggerConfigurer,
			MvcSecurityCleanUpInterceptorHandler mvcSecurityCleanUpInterceptorHandler) {
		super(actionInvocation, mvcSecurityAuthorityFilter,
				supportActionExceptionHandler, auditActionLoggerConfigurer,
				mvcSecurityCleanUpInterceptorHandler);

	}

	@Override
	protected void doValidateAfterPreparation() {

		super.doValidateAfterPreparation();

		// MvcContext must be provided
		if (TypeChecker.isNull(ActionContextUtils.getMvcMethodConfigurer())) {
			throw new ActionMvcMethodConfigurerLostApplicationException(
					"Please provide a MvcMethodConfigurer Annotation under ["
							+ ActionContextUtils.getActionMethod().getName()
							+ "/"
							+ this.actionInvocation.getAction().getClass()
									.getSimpleName() + "]");
		}

	}
}
