package com.rapid.j2ee.framework.mvc.webservice.text;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.StreamIoUtils;
import com.rapid.j2ee.framework.core.utils.StringUtils;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.ViewerType;
import com.rapid.j2ee.framework.mvc.utils.StreamResult;
import com.rapid.j2ee.framework.mvc.web.annotation.StreamFieldAttribute;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContext;
import com.rapid.j2ee.framework.mvc.web.text.AbstractMvcMethodContextFormatText;

@Component
public class MvcMethodContextFormatStreamText extends
		AbstractMvcMethodContextFormatText<byte[]> {

	public byte[] doResolveMethodContext(MvcMethodContext mvcMethodContext,
			String charset) {

		Map<String, Object> results = new HashMap<String, Object>(5);

		StreamResult streamResult = new StreamResult(String
				.valueOf(mvcMethodContext.getResultCode()), mvcMethodContext
				.getMessage());

		results.put("stream-header", streamResult);

		for (Field field : ClassUtils.getAllFieldsAsClassByAnnotation(
				mvcMethodContext.getClass(), StreamFieldAttribute.class)) {

			Object fieldValue = InvokeUtils.getFieldValue(mvcMethodContext,
					field);

			if (TypeChecker.isNull(fieldValue)) {
				continue;
			}
			results.put(StringUtils.convertFieldNameToXmlTagName(StringUtils
					.trimToEmpty(
							((StreamFieldAttribute) field
									.getAnnotation(StreamFieldAttribute.class))
									.key(), field.getName()).toLowerCase()),
					fieldValue);
		}

		return StreamIoUtils.getObjectToBytes(results);
	}

	public ViewerType resolveType() {

		return ViewerType.Stream;
	}

	public static void main(String[] args) {

	}

}
