package com.rapid.j2ee.framework.mvc.webservice.text;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

import com.rapid.j2ee.framework.core.io.xml.XmlFieldAttribute;
import com.rapid.j2ee.framework.core.io.xml.XmlWriteBuilder;
import com.rapid.j2ee.framework.core.io.xml.XmlWriter;
import com.rapid.j2ee.framework.core.reflect.InvokeUtils;
import com.rapid.j2ee.framework.core.spring.SpringPropertiesHolder;
import com.rapid.j2ee.framework.core.utils.ClassUtils;
import com.rapid.j2ee.framework.core.utils.StatusTypes;
import com.rapid.j2ee.framework.core.utils.TypeChecker;
import com.rapid.j2ee.framework.mvc.constants.ViewerType;
import com.rapid.j2ee.framework.mvc.security.version.AbstractMvcApplicationVersionVerfication;
import com.rapid.j2ee.framework.mvc.security.version.MvcApplicationVersionVerfication;
import com.rapid.j2ee.framework.mvc.utils.ActionContextUtils;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodContext;
import com.rapid.j2ee.framework.mvc.web.context.MvcMethodEmptyContext;
import com.rapid.j2ee.framework.mvc.web.text.AbstractMvcMethodContextFormatText;

@Component
public class MvcMethodContextFormatXmlText extends
		AbstractMvcMethodContextFormatText<String> {

	public String doResolveMethodContext(MvcMethodContext mvcMethodContext,
			String charset) {

		boolean humpTagType = getHumpTagType();

		XmlWriter xmlWriter = new XmlWriter(charset);

		xmlWriter.addRootElement("output");

		xmlWriter.addElement("head");

		xmlWriter.addElement("code");
		xmlWriter.addElementText(String.valueOf(mvcMethodContext
				.getResultCode()));
		xmlWriter.previousElement();

		xmlWriter.addElement("message");

		xmlWriter.addElementText(mvcMethodContext.getMessage());

		xmlWriter.previousElement();

		xmlWriter.addElement("message-key");

		xmlWriter.addElementText(mvcMethodContext.getMessageCode());

		xmlWriter.moveElementByFullNodePath("output");

		if (mvcMethodContext instanceof MvcMethodEmptyContext) {

			if (((MvcMethodEmptyContext) mvcMethodContext).isEmpty()) {

				return xmlWriter.toXmlText();
			}
		}

		xmlWriter.addElement("body");

		XmlWriteBuilder xmlWriteBuilder = new XmlWriteBuilder(xmlWriter,
				humpTagType);

		xmlWriteBuilder.addXmlItems(this
				.getMvcMethodContextXmlFieldValues(mvcMethodContext));

		return xmlWriteBuilder.toXmlText();
	}

	private Object[] getMvcMethodContextXmlFieldValues(
			MvcMethodContext mvcMethodContext) {

		List xmlFieldValues = new ArrayList();

		for (Field field : ClassUtils.getAllFieldsAsClassByAnnotation(
				mvcMethodContext.getClass(), XmlFieldAttribute.class)) {

			Object result = InvokeUtils.getFieldValue(mvcMethodContext, field);

			if (TypeChecker.isEmptyObject(result)) {
				continue;
			}

			xmlFieldValues.add(result);
		}

		return xmlFieldValues.toArray(new Object[xmlFieldValues.size()]);
	}

	private boolean getHumpTagType() {
		try {

			// 需要版本更新
			if (TypeChecker
					.isSpecialTrue(String
							.valueOf(ActionContextUtils
									.getStrutActionContext()
									.get(
											MvcApplicationVersionVerfication.WebServiceApplicationVersionVerfication_Stack_Parameter)))) {

				return TypeChecker
						.isSpecialTrue(SpringPropertiesHolder
								.getProperty(
										"CoreWebServiceApplicationVersionVerfication.VersionValidator.HumpTagType",
										"Y"));

			}

			return TypeChecker.isSpecialTrue(ActionContextUtils
					.getHttpParameter("humpTagType", "Y"));
		} catch (Exception e) {
			return true;
		}
	}

	public ViewerType resolveType() {

		return ViewerType.Xml;
	}

}
